/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources;

import org.gradle.api.Describable;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jspecify.annotations.Nullable;

public abstract class EnvironmentVariableValueSource
implements ValueSource<String, Parameters>,
Describable {
    public @Nullable String obtain() {
        @Nullable String variableName = this.variableNameOrNull();
        if (variableName == null) {
            return null;
        }
        return System.getenv(variableName);
    }

    public String getDisplayName() {
        return String.format("environment variable '%s'", this.variableNameOrNull());
    }

    private String variableNameOrNull() {
        return (String)((Parameters)this.getParameters()).getVariableName().getOrNull();
    }

    public static interface Parameters
    extends ValueSourceParameters {
        public Property<String> getVariableName();
    }
}

