/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.encryption.impl;

import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.encryption.impl.SecretKeySource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u0007H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/gradle/internal/encryption/impl/EnvironmentVarKeySource;", "Lorg/gradle/internal/encryption/impl/SecretKeySource;", "encryptionAlgorithm", "", "<init>", "(Ljava/lang/String;)V", "secretKey", "Ljavax/crypto/SecretKey;", "getSecretKey", "()Ljavax/crypto/SecretKey;", "secretKey$delegate", "Lkotlin/Lazy;", "getKeyAsBase64", "getKey", "sourceDescription", "getSourceDescription", "()Ljava/lang/String;", "Companion", "encryption-services"})
public final class EnvironmentVarKeySource
implements SecretKeySource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy secretKey$delegate;
    @NotNull
    public static final String GRADLE_ENCRYPTION_KEY_ENV_KEY = "GRADLE_ENCRYPTION_KEY";

    public EnvironmentVarKeySource(@NotNull String encryptionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm, (String)"encryptionAlgorithm");
        this.secretKey$delegate = LazyKt.lazy(() -> EnvironmentVarKeySource.secretKey_delegate$lambda$1(this, encryptionAlgorithm));
    }

    private final SecretKey getSecretKey() {
        Lazy lazy = this.secretKey$delegate;
        return (SecretKey)lazy.getValue();
    }

    private final String getKeyAsBase64() {
        String string = System.getenv(GRADLE_ENCRYPTION_KEY_ENV_KEY);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public SecretKey getKey() {
        return this.getSecretKey();
    }

    @Override
    @NotNull
    public String getSourceDescription() {
        return "GRADLE_ENCRYPTION_KEY environment variable";
    }

    private static final SecretKeySpec secretKey_delegate$lambda$1(EnvironmentVarKeySource this$0, String $encryptionAlgorithm) {
        byte[] keyAsBytes = Base64.getDecoder().decode(this$0.getKeyAsBase64());
        boolean bl = false;
        return new SecretKeySpec(keyAsBytes, $encryptionAlgorithm);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gradle/internal/encryption/impl/EnvironmentVarKeySource$Companion;", "", "<init>", "()V", "GRADLE_ENCRYPTION_KEY_ENV_KEY", "", "encryption-services"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

