/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.testng.TestNGListenerAdapterFactory;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestResultProcessorAdapter;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.time.Clock;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GFileUtils;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.TestNG;

public class TestNGTestRunner {
    public static final String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private final File testReportDir;
    private final List<File> suiteFiles;
    private final IdGenerator<?> idGenerator;
    private final Clock clock;
    private final TestResultProcessor resultProcessor;
    private final ClassLoader applicationClassLoader;
    private final TestNGSpec spec;
    private final List<Class<?>> testClasses;

    public TestNGTestRunner(File testReportDir, List<File> suiteFiles, IdGenerator<?> idGenerator, Clock clock, TestResultProcessor resultProcessor, ClassLoader applicationClassLoader, TestNGSpec spec, List<Class<?>> testClasses) {
        this.testReportDir = testReportDir;
        this.suiteFiles = suiteFiles;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.resultProcessor = resultProcessor;
        this.applicationClassLoader = applicationClassLoader;
        this.spec = spec;
        this.testClasses = testClasses;
    }

    public void runTests() {
        TestNG testNg = new TestNG();
        testNg.setOutputDirectory(this.testReportDir.getAbsolutePath());
        testNg.setDefaultSuiteName(this.spec.getDefaultSuiteName());
        testNg.setDefaultTestName(this.spec.getDefaultTestName());
        if (this.spec.getParallel() != null) {
            testNg.setParallel(this.spec.getParallel());
        }
        if (this.spec.getThreadCount() > 0) {
            testNg.setThreadCount(this.spec.getThreadCount());
        }
        this.setSuiteThreadPoolSize(testNg, this.spec.getSuiteThreadPoolSize());
        this.setConfigFailurePolicy(testNg, this.spec.getConfigFailurePolicy());
        this.setPreserveOrder(testNg, this.spec.getPreserveOrder());
        this.setGroupByInstances(testNg, this.spec.getGroupByInstances());
        String className = this.spec.getThreadPoolFactoryClass();
        if (className != null && !className.isEmpty()) {
            this.setThreadPoolFactoryClass(testNg, this.spec.getThreadPoolFactoryClass());
        }
        testNg.setUseDefaultListeners(this.spec.getUseDefaultListeners());
        testNg.setVerbose(0);
        testNg.setGroups(CollectionUtils.join((String)",", this.spec.getIncludeGroups()));
        testNg.setExcludedGroups(CollectionUtils.join((String)",", this.spec.getExcludeGroups()));
        for (String listenerClass : this.spec.getListeners()) {
            try {
                testNg.addListener(JavaReflectionUtil.newInstance(this.applicationClassLoader.loadClass(listenerClass)));
            }
            catch (Throwable e) {
                throw new GradleException(String.format("Could not add a test listener with class '%s'.", listenerClass), e);
            }
        }
        TestFilterSpec filter = this.spec.getFilter();
        if (!(filter.getIncludedTests().isEmpty() && filter.getIncludedTestsCommandLine().isEmpty() && filter.getExcludedTests().isEmpty())) {
            testNg.addListener((Object)new SelectedTestsFilter(filter));
        }
        if (!this.suiteFiles.isEmpty()) {
            testNg.setTestSuites(GFileUtils.toPaths(this.suiteFiles));
        } else {
            testNg.setTestClasses(this.testClasses.toArray(new Class[0]));
        }
        TestNGTestResultProcessorAdapter listener = new TestNGTestResultProcessorAdapter(this.resultProcessor, this.idGenerator, this.clock);
        TestNGListenerAdapterFactory factory = new TestNGListenerAdapterFactory(this.applicationClassLoader);
        testNg.addListener((Object)factory.createAdapter(listener));
        testNg.run();
    }

    private void setConfigFailurePolicy(TestNG testNg, String value) {
        block4: {
            Object argValue;
            Class argType;
            try {
                argType = Class.forName("org.testng.xml.XmlSuite$FailurePolicy", false, testNg.getClass().getClassLoader());
                argValue = argType.getMethod("getValidPolicy", String.class).invoke(null, value);
            }
            catch (Exception e) {
                argType = String.class;
                argValue = value;
            }
            try {
                JavaMethod.of(TestNG.class, Object.class, (String)"setConfigFailurePolicy", (Class[])new Class[]{argType}).invoke((Object)testNg, new Object[]{argValue});
            }
            catch (NoSuchMethodException e) {
                if (argValue.equals(DEFAULT_CONFIG_FAILURE_POLICY)) break block4;
                String message = String.format("The version of TestNG used does not support setting config failure policy to '%s'.", value);
                throw new InvalidUserDataException(message);
            }
        }
    }

    private void setPreserveOrder(TestNG testNg, boolean value) {
        block2: {
            try {
                JavaMethod.of(TestNG.class, Object.class, (String)"setPreserveOrder", (Class[])new Class[]{Boolean.TYPE}).invoke((Object)testNg, new Object[]{value});
            }
            catch (NoSuchMethodException e) {
                if (!value) break block2;
                throw new InvalidUserDataException("Preserving the order of tests is not supported by this version of TestNG.");
            }
        }
    }

    private void setGroupByInstances(TestNG testNg, boolean value) {
        block2: {
            try {
                JavaMethod.of(TestNG.class, Object.class, (String)"setGroupByInstances", (Class[])new Class[]{Boolean.TYPE}).invoke((Object)testNg, new Object[]{value});
            }
            catch (NoSuchMethodException e) {
                if (!value) break block2;
                throw new InvalidUserDataException("Grouping tests by instances is not supported by this version of TestNG.");
            }
        }
    }

    private void setThreadPoolFactoryClass(TestNG testNg, String threadPoolFactoryClass) {
        try {
            JavaMethod.of(TestNG.class, Object.class, (String)"setExecutorFactoryClass", (Class[])new Class[]{String.class}).invoke((Object)testNg, new Object[]{threadPoolFactoryClass});
        }
        catch (NoSuchMethodException e) {
            throw new InvalidUserDataException("The version of TestNG used does not support setting thread pool factory class.");
        }
    }

    private void setSuiteThreadPoolSize(TestNG testNg, Integer suiteThreadPoolSize) {
        block3: {
            if (suiteThreadPoolSize < 1) {
                throw new InvalidUserDataException("suiteThreadPoolSize must be greater than or equal to 1.");
            }
            try {
                JavaMethod.of(TestNG.class, Object.class, (String)"setSuiteThreadPoolSize", (Class[])new Class[]{Integer.class}).invoke((Object)testNg, new Object[]{suiteThreadPoolSize});
            }
            catch (NoSuchMethodException e) {
                if (suiteThreadPoolSize == 1) break block3;
                throw new InvalidUserDataException("The version of TestNG used does not support setting thread pool size.");
            }
        }
    }

    private static class SelectedTestsFilter
    implements IMethodInterceptor {
        private final TestSelectionMatcher matcher;

        public SelectedTestsFilter(TestFilterSpec filter) {
            this.matcher = new TestSelectionMatcher(filter);
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            ISuite suite = context.getSuite();
            LinkedList<IMethodInstance> filtered = new LinkedList<IMethodInstance>();
            for (IMethodInstance candidate : methods) {
                if (!this.matcher.matchesTest(candidate.getMethod().getTestClass().getName(), candidate.getMethod().getMethodName()) && !this.matcher.matchesTest(suite.getName(), null)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }
}

