/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.util.internal.GUtil;

public class XcodePropertyAdapter {
    private final Project project;

    public XcodePropertyAdapter(Project project) {
        this.project = project;
    }

    public String getAction() {
        return this.getXcodeProperty("ACTION");
    }

    public String getProductName() {
        return this.getXcodeProperty("PRODUCT_NAME");
    }

    public String getConfiguration() {
        return this.getXcodeProperty("CONFIGURATION");
    }

    public String getBuiltProductsDir() {
        return this.getXcodeProperty("BUILT_PRODUCTS_DIR");
    }

    private String getXcodeProperty(String name) {
        return String.valueOf(GUtil.elvis((Object)this.project.findProperty(XcodePropertyAdapter.prefixName(name)), (Object)""));
    }

    public static List<String> getAdapterCommandLine() {
        return Arrays.asList(XcodePropertyAdapter.toGradleProperty("ACTION"), XcodePropertyAdapter.toGradleProperty("PRODUCT_NAME"), XcodePropertyAdapter.toGradleProperty("CONFIGURATION"), XcodePropertyAdapter.toGradleProperty("BUILT_PRODUCTS_DIR"));
    }

    private static String toGradleProperty(String source) {
        return "-P" + XcodePropertyAdapter.prefixName(source) + "=\"${" + source + "}\"";
    }

    private static String prefixName(String source) {
        return "org.gradle.internal.xcode.bridge." + source;
    }
}

