/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.PropertiesFileHandler;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ConnectionConfigurationUtil {
    public static Map<String, String> determineSystemProperties(ConnectionParameters connectionParameters) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            systemProperties.put(entry.getKey().toString(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        systemProperties.putAll(PropertiesFileHandler.getSystemProperties((File)new File(ConnectionConfigurationUtil.determineRootDir(connectionParameters), "gradle.properties")));
        systemProperties.putAll(PropertiesFileHandler.getSystemProperties((File)new File(ConnectionConfigurationUtil.determineRealUserHomeDir(connectionParameters), "gradle.properties")));
        return systemProperties;
    }

    public static List<String> determineJvmArguments(ConnectionParameters connectionParameters) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(PropertiesFileHandler.getJvmArgs((File)new File(ConnectionConfigurationUtil.determineRootDir(connectionParameters), "gradle.properties")));
        jvmArgs.addAll(PropertiesFileHandler.getJvmArgs((File)new File(ConnectionConfigurationUtil.determineRealUserHomeDir(connectionParameters), "gradle.properties")));
        return jvmArgs;
    }

    public static File determineRootDir(ConnectionParameters connectionParameters) {
        return new BuildLayoutFactory().getLayoutFor(connectionParameters.getProjectDir(), connectionParameters.isSearchUpwards() != null ? connectionParameters.isSearchUpwards() : true).getRootDirectory();
    }

    public static File determineRealUserHomeDir(ConnectionParameters connectionParameters) {
        File distributionBaseDir = connectionParameters.getDistributionBaseDir();
        if (distributionBaseDir != null) {
            return distributionBaseDir;
        }
        File userHomeDir = connectionParameters.getGradleUserHomeDir();
        return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
    }
}

