/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.jspecify.annotations.NonNull;

@ServiceScope(value={Scope.BuildSession.class})
public class SystemPathVersionLocator
implements VisualStudioVersionLocator {
    private static final String LEGACY_COMPILER_FILENAME = "cl.exe";
    private static final Logger LOGGER = Logging.getLogger(SystemPathVersionLocator.class);
    private final OperatingSystem os;
    private final VisualStudioMetaDataProvider versionDeterminer;

    public SystemPathVersionLocator(OperatingSystem os, VisualStudioMetaDataProvider versionDeterminer) {
        this.os = os;
        this.versionDeterminer = versionDeterminer;
    }

    @Override
    public @NonNull List<VisualStudioInstallCandidate> getVisualStudioInstalls() {
        ArrayList<VisualStudioInstallCandidate> installs = new ArrayList<VisualStudioInstallCandidate>();
        File compilerInPath = this.os.findInPath(LEGACY_COMPILER_FILENAME);
        if (compilerInPath == null) {
            LOGGER.debug("No visual c++ compiler found in system path.");
        } else {
            VisualStudioInstallCandidate install = this.versionDeterminer.getVisualStudioMetadataFromCompiler(compilerInPath);
            if (install != null) {
                installs.add(install);
            }
        }
        return installs;
    }

    @Override
    public String getSource() {
        return "system path";
    }
}

