/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.DefaultComponentArtifactResolver;
import org.gradle.internal.resolve.resolver.ResolvedVariantCache;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;
import org.jspecify.annotations.Nullable;

public class DefaultVariantArtifactResolver
implements VariantArtifactResolver {
    private final ImmutableArtifactTypeRegistry artifactTypeRegistry;
    private final ArtifactResolver artifactResolver;
    private final ResolvedVariantCache resolvedVariantCache;

    public DefaultVariantArtifactResolver(ArtifactResolver artifactResolver, ImmutableArtifactTypeRegistry artifactTypeRegistry, ResolvedVariantCache resolvedVariantCache) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactResolver = artifactResolver;
        this.resolvedVariantCache = resolvedVariantCache;
    }

    @Override
    public ResolvedVariant resolveAdhocVariant(ComponentArtifactResolveMetadata component, VariantIdentifier sourceVariantId, ImmutableList<? extends ComponentArtifactMetadata> artifacts) {
        SingleArtifactVariantIdentifier identifier = artifacts.size() == 1 ? new SingleArtifactVariantIdentifier(((ComponentArtifactMetadata)artifacts.iterator().next()).getId()) : null;
        DefaultVariantMetadata adhoc = new DefaultVariantMetadata("adhoc", identifier, Describables.of((Object)"adhoc variant for", (Object)component.getId()), component.getAttributes(), artifacts, ImmutableCapabilities.EMPTY);
        return this.resolveVariantArtifactSet(component, sourceVariantId, adhoc);
    }

    @Override
    public ResolvedVariant resolveVariantArtifactSet(ComponentArtifactResolveMetadata component, VariantIdentifier sourceVariantId, VariantResolveMetadata variantArtifacts) {
        ImmutableList<? extends ComponentArtifactMetadata> artifacts = variantArtifacts.getArtifacts();
        VariantResolveMetadata.Identifier artifactSetId = variantArtifacts.getIdentifier();
        if (artifactSetId == null || !variantArtifacts.isEligibleForCaching()) {
            return this.createResolvedVariant(artifactSetId, sourceVariantId, component, variantArtifacts, this.artifactTypeRegistry, artifacts);
        }
        ResolvedVariantCache.CacheKey key = new ResolvedVariantCache.CacheKey(artifactSetId, this.artifactTypeRegistry);
        ResolvedVariant value = this.resolvedVariantCache.get(key);
        if (value != null) {
            return value;
        }
        return this.resolvedVariantCache.computeIfAbsent(key, k -> this.createResolvedVariant(k.variantIdentifier, sourceVariantId, component, variantArtifacts, k.artifactTypeRegistry, artifacts));
    }

    private ResolvedVariant createResolvedVariant(@Nullable VariantResolveMetadata.Identifier identifier, VariantIdentifier sourceVariantId, ComponentArtifactResolveMetadata component, VariantResolveMetadata artifactVariant, ImmutableArtifactTypeRegistry artifactTypeRegistry, ImmutableList<? extends ComponentArtifactMetadata> artifacts) {
        ImmutableAttributes attributes = artifactTypeRegistry.mapAttributesFor(artifactVariant.getAttributes(), (Iterable<? extends ComponentArtifactMetadata>)artifacts);
        ImmutableCapabilities capabilities = DefaultVariantArtifactResolver.withImplicitCapability(artifactVariant.getCapabilities(), component);
        return new ArtifactBackedResolvedVariant(identifier, sourceVariantId, artifactVariant.asDescribable(), attributes, capabilities, (List<? extends ComponentArtifactMetadata>)artifacts, new DefaultComponentArtifactResolver(component, this.artifactResolver));
    }

    private static ImmutableCapabilities withImplicitCapability(ImmutableCapabilities capabilities, ComponentArtifactResolveMetadata component) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(component.getModuleVersionId()));
        }
        return capabilities;
    }

    private static class SingleArtifactVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final ComponentArtifactIdentifier artifactIdentifier;

        public SingleArtifactVariantIdentifier(ComponentArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public int hashCode() {
            return this.artifactIdentifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SingleArtifactVariantIdentifier other = (SingleArtifactVariantIdentifier)obj;
            return this.artifactIdentifier.equals(other.artifactIdentifier);
        }
    }
}

