/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ImplicitInputsCapturingInstantiator
implements Instantiator {
    private final ServiceRegistry serviceRegistry;
    private final InstantiatorFactory factory;

    public ImplicitInputsCapturingInstantiator(ServiceRegistry serviceRegistry, InstantiatorFactory factory) {
        this.serviceRegistry = serviceRegistry;
        this.factory = factory;
    }

    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return (T)this.factory.inject((ServiceLookup)this.serviceRegistry).newInstance(type, parameters);
    }

    public Instantiator capturing(final ImplicitInputRecorder registrar) {
        return new Instantiator(){

            public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
                return (T)ImplicitInputsCapturingInstantiator.this.factory.inject((ServiceLookup)ImplicitInputsCapturingInstantiator.this.capturingRegistry(registrar)).newInstance(type, parameters);
            }
        };
    }

    public <IN, OUT, SERVICE> @Nullable ImplicitInputsProvidingService<IN, OUT, SERVICE> findInputCapturingServiceByName(String name) {
        try {
            return (ImplicitInputsProvidingService)Cast.uncheckedCast((Object)this.serviceRegistry.find(Class.forName(name)));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ServiceRegistry capturingRegistry(ImplicitInputRecorder registrar) {
        return new DefaultCapturingServicesRegistry(registrar);
    }

    private class DefaultCapturingServicesRegistry
    implements ServiceRegistry {
        private final ImplicitInputRecorder registrar;

        private DefaultCapturingServicesRegistry(ImplicitInputRecorder registrar) {
            this.registrar = registrar;
        }

        public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
            return (T)ImplicitInputsCapturingInstantiator.this.serviceRegistry.get(serviceType);
        }

        public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.getAll(serviceType);
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.get(serviceType);
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.get(serviceType, annotatedWith);
        }

        public Object find(Type serviceType) throws ServiceLookupException {
            Object service = ImplicitInputsCapturingInstantiator.this.serviceRegistry.find(serviceType);
            if (service instanceof ImplicitInputsProvidingService) {
                return ((ImplicitInputsProvidingService)service).withImplicitInputRecorder(this.registrar);
            }
            return service;
        }
    }
}

