/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.jspecify.annotations.Nullable;

public class DependencyMapNotationConverter<T>
extends MapNotationConverter<T> {
    private final Instantiator instantiator;
    private final Class<T> resultingType;

    public DependencyMapNotationConverter(Instantiator instantiator, Class<T> resultingType) {
        this.instantiator = instantiator;
        this.resultingType = resultingType;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("Maps").example("[group: 'org.gradle', name: 'gradle-core', version: '1.0']");
    }

    protected T parseMap(@MapKey(value="group") @Nullable String group, @MapKey(value="name") @Nullable String name, @MapKey(value="version") @Nullable String version, @MapKey(value="configuration") @Nullable String configuration, @MapKey(value="ext") @Nullable String ext, @MapKey(value="classifier") @Nullable String classifier) {
        DeprecationMessageBuilder.DeprecateAction deprecation = DeprecationLogger.deprecateAction((String)"Declaring dependencies using multi-string notation");
        if (configuration == null) {
            String suggestedNotation = (group == null ? "" : group) + ":" + name + (version == null ? "" : ":" + version);
            if (classifier != null) {
                if (version == null) {
                    suggestedNotation = suggestedNotation + ":";
                }
                suggestedNotation = suggestedNotation + ":" + classifier;
            }
            if (ext != null) {
                suggestedNotation = suggestedNotation + "@" + ext;
            }
            deprecation = (DeprecationMessageBuilder.DeprecateAction)deprecation.withAdvice("Please use single-string notation instead: \"" + suggestedNotation + "\".");
        }
        ((DeprecationMessageBuilder.WithDocumentation)deprecation.willBecomeAnErrorInGradle10().withUpgradeGuideSection(9, "dependency_multi_string_notation")).nagUser();
        Object dependency = configuration == null ? this.instantiator.newInstance(this.resultingType, new Object[]{group, name, version}) : this.instantiator.newInstance(this.resultingType, new Object[]{group, name, version, configuration});
        if (dependency instanceof ExternalDependency) {
            ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)dependency, ext, classifier);
        }
        return (T)dependency;
    }
}

