/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.List;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.attributes.matching.AttributeMatchingCandidate;
import org.jspecify.annotations.Nullable;

public interface AttributeMatcher {
    public boolean isMatchingCandidate(ImmutableAttributes var1, ImmutableAttributes var2);

    public boolean areMutuallyCompatible(ImmutableAttributes var1, ImmutableAttributes var2);

    public <T> boolean isMatchingValue(Attribute<T> var1, T var2, T var3);

    public <T extends AttributeMatchingCandidate> List<T> matchMultipleCandidates(List<? extends T> var1, ImmutableAttributes var2);

    public List<MatchingDescription<?>> describeMatching(ImmutableAttributes var1, ImmutableAttributes var2);

    public static class MatchingDescription<T> {
        private final ImmutableAttributesEntry<T> requested;
        private final @Nullable ImmutableAttributesEntry<T> found;
        private final boolean match;

        public MatchingDescription(ImmutableAttributesEntry<T> requested, @Nullable ImmutableAttributesEntry<T> found, boolean match) {
            this.requested = requested;
            this.found = found;
            this.match = match;
        }

        public ImmutableAttributesEntry<T> getRequested() {
            return this.requested;
        }

        public @Nullable ImmutableAttributesEntry<T> getFound() {
            return this.found;
        }

        public boolean isMatch() {
            return this.match;
        }
    }
}

