/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report;

import java.nio.file.Path;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.DependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationHighLevelErrors;
import org.gradle.internal.logging.text.TreeFormatter;

abstract class AbstractTextDependencyVerificationReportRenderer
implements DependencyVerificationReportRenderer {
    protected final Path gradleUserHome;
    protected final DocumentationRegistry documentationRegistry;
    protected TreeFormatter formatter;

    public AbstractTextDependencyVerificationReportRenderer(Path gradleUserHome, DocumentationRegistry documentationRegistry) {
        this.gradleUserHome = gradleUserHome;
        this.documentationRegistry = documentationRegistry;
    }

    protected void legend(String legendItem) {
        this.formatter.node(legendItem);
    }

    @Override
    public void finish(VerificationHighLevelErrors highLevelErrors) {
        if (highLevelErrors.isMaybeCompromised()) {
            StringBuilder sb = new StringBuilder();
            sb.append("This can indicate that a dependency has been compromised. Please carefully verify the ");
            if (highLevelErrors.hasFailedSignatures()) {
                sb.append("signatures and ");
            }
            sb.append("checksums.");
            if (highLevelErrors.hasFailedSignatures() && highLevelErrors.isKeyServersDisabled()) {
                sb.append(" Key servers are disabled, this can indicate that you need to update the local keyring with the missing keys.");
            }
            this.legend(sb.toString());
        }
        if (highLevelErrors.canSuggestWriteMetadata()) {
            this.legend("If the artifacts are trustworthy, you will need to update the gradle/verification-metadata.xml file. " + this.documentationRegistry.getDocumentationRecommendationFor("on how to do this", "dependency_verification", "sec:troubleshooting-verification"));
        }
    }

    String render() {
        return this.formatter.toString();
    }
}

