/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.util.Node;
import groovy.xml.XmlParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.XmlProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class XmlPersistableConfigurationObject
extends AbstractPersistableConfigurationObject {
    private final XmlTransformer xmlTransformer;
    private Node xml;

    protected XmlPersistableConfigurationObject(XmlTransformer xmlTransformer) {
        this.xmlTransformer = xmlTransformer;
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.xml = new XmlParser().parse(inputStream);
        this.load(this.xml);
    }

    @Override
    public void store(OutputStream outputStream) {
        this.store(this.xml);
        this.xmlTransformer.transform(this.xml, outputStream);
    }

    public Node getXml() {
        return this.xml;
    }

    protected void load(Node xml) {
    }

    protected void store(Node xml) {
    }

    public void transformAction(@DelegatesTo(value=XmlProvider.class) Closure action) {
        this.transformAction((Action<? super XmlProvider>)ConfigureUtil.configureUsing((Closure)action));
    }

    public void transformAction(Action<? super XmlProvider> action) {
        this.xmlTransformer.addAction(action);
    }

    protected static List<Node> getChildren(@Nullable Node root, String name) {
        return root == null ? Collections.emptyList() : (List)Cast.uncheckedCast((Object)root.get(name));
    }

    public static @Nullable Node findFirstChildNamed(@Nullable Node root, String name) {
        return root == null ? null : (Node)Iterables.getFirst(XmlPersistableConfigurationObject.getChildren(root, name), null);
    }

    public static @Nullable Node findFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        return root == null ? null : XmlPersistableConfigurationObject.findFirstWithAttributeValue(XmlPersistableConfigurationObject.getChildren(root, childName), attribute, value);
    }

    protected static @Nullable Node findFirstWithAttributeValue(@Nullable List<Node> nodes, final String attribute, final String value) {
        return nodes == null ? null : (Node)Iterables.getFirst((Iterable)Iterables.filter(nodes, (Predicate)new Predicate<Node>(){

            public boolean apply(Node node) {
                return value.equals(node.attribute((Object)attribute));
            }
        }), null);
    }

    public static Node findOrCreateFirstChildNamed(Node root, String name) {
        Node child = XmlPersistableConfigurationObject.findFirstChildNamed(root, name);
        if (child == null) {
            child = root.appendNode((Object)name);
        }
        return child;
    }

    public static Node findOrCreateFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        Node child = XmlPersistableConfigurationObject.findFirstChildWithAttributeValue(root, childName, attribute, value);
        if (child == null) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put(attribute, value);
            child = root.appendNode((Object)childName, attributes);
        }
        return child;
    }
}

