/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import org.gradle.api.file.UserClassFilePermissions;

public abstract class AbstractUserClassFilePermissions
implements UserClassFilePermissions {
    protected int toUnixNumeric() {
        return (this.getRead() ? 4 : 0) + (this.getWrite() ? 2 : 0) + (this.getExecute() ? 1 : 0);
    }

    protected static boolean isRead(int unixNumeric) {
        return (unixNumeric & 4) >> 2 == 1;
    }

    protected static boolean isRead(String unixSymbolic) {
        char symbol = unixSymbolic.charAt(0);
        if (symbol == 'r') {
            return true;
        }
        if (symbol == '-') {
            return false;
        }
        throw new IllegalArgumentException("'" + symbol + "' is not a valid Unix permission READ flag, must be 'r' or '-'.");
    }

    protected static boolean isWrite(int unixNumeric) {
        return (unixNumeric & 2) >> 1 == 1;
    }

    protected static boolean isWrite(String unixSymbolic) {
        char symbol = unixSymbolic.charAt(1);
        if (symbol == 'w') {
            return true;
        }
        if (symbol == '-') {
            return false;
        }
        throw new IllegalArgumentException("'" + symbol + "' is not a valid Unix permission WRITE flag, must be 'w' or '-'.");
    }

    protected static boolean isExecute(int unixNumeric) {
        return (unixNumeric & 1) == 1;
    }

    protected static boolean isExecute(String unixSymbolic) {
        char symbol = unixSymbolic.charAt(2);
        if (symbol == 'x') {
            return true;
        }
        if (symbol == '-') {
            return false;
        }
        throw new IllegalArgumentException("'" + symbol + "' is not a valid Unix permission EXECUTE flag, must be 'x' or '-'.");
    }
}

