/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dependencies;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphsRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.SimpleNodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class AsciiDependencyReportRenderer
extends TextReportRenderer
implements DependencyReportRenderer {
    private final ConfigurationDetailsAction configurationDetailsAction = new ConfigurationDetailsAction();
    private boolean hasConfigs;
    private GraphRenderer renderer;
    DependencyGraphsRenderer dependencyGraphRenderer;

    public void startProject(ProjectDetails project) {
        super.startProject(project);
        this.prepareVisit();
    }

    void prepareVisit() {
        this.hasConfigs = false;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.dependencyGraphRenderer = new DependencyGraphsRenderer(this.getTextOutput(), this.renderer, NodeRenderer.NO_OP, new SimpleNodeRenderer());
    }

    public void completeProject(ProjectDetails project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No configurations");
        }
        super.completeProject(project);
    }

    @Override
    public void startConfiguration(ConfigurationDetails configuration) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.configurationDetailsAction.setConfiguration(configuration);
        this.renderer.visit((Action)this.configurationDetailsAction, true);
    }

    @Override
    public void completeConfiguration(ConfigurationDetails configuration) {
    }

    @Override
    public void render(ConfigurationDetails configuration) {
        if (configuration.isCanBeResolved()) {
            ResolvedComponentResult result = (ResolvedComponentResult)configuration.getResolutionResultRoot().get();
            RenderableModuleResult root = new RenderableModuleResult(result);
            this.renderNow(root);
        } else {
            this.renderNow(configuration.getUnresolvableResult());
        }
    }

    void renderNow(RenderableDependency root) {
        if (root.getChildren().isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)"No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.dependencyGraphRenderer.render(Collections.singletonList(root));
    }

    public void complete() {
        if (this.dependencyGraphRenderer != null) {
            this.dependencyGraphRenderer.complete();
        }
        this.getTextOutput().println();
        this.getTextOutput().text((Object)"A web-based, searchable dependency report is available by adding the ");
        this.getTextOutput().withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        this.getTextOutput().println((Object)" option.");
        super.complete();
    }

    private class ConfigurationDetailsAction
    implements Action<StyledTextOutput> {
        private ConfigurationDetails configuration;

        private ConfigurationDetailsAction() {
        }

        public void setConfiguration(ConfigurationDetails configuration) {
            this.configuration = configuration;
        }

        public void execute(StyledTextOutput styledTextOutput) {
            AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)this.configuration.getName());
            AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)this.getDescription(this.configuration));
            if (!this.configuration.isCanBeResolved()) {
                AsciiDependencyReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)" (n)");
            }
        }

        private String getDescription(ConfigurationDetails configuration) {
            String description = configuration.getDescription();
            description = description != null && !description.isEmpty() ? " - " + description : "";
            return description;
        }
    }
}

