/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import org.gradle.api.artifacts.PublishException;
import org.gradle.api.attributes.Category;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.component.SoftwareComponentInternal;

public abstract class PublicationErrorChecker {
    public static void checkForUnpublishableAttributes(SoftwareComponentInternal component, DocumentationRegistry documentationRegistry) {
        for (SoftwareComponentVariant variant : component.getUsages()) {
            variant.getAttributes().keySet().stream().filter(attribute -> Category.CATEGORY_ATTRIBUTE.getName().equals(attribute.getName())).findFirst().ifPresent(attribute -> {
                Object value = variant.getAttributes().getAttribute(attribute);
                if (value != null && "verification".equals(value.toString())) {
                    throw new PublishException("Cannot publish module metadata for component '" + component.getName() + "' which would include a variant '" + variant.getName() + "' that contains a '" + Category.CATEGORY_ATTRIBUTE.getName() + "' attribute with a value of '" + "verification" + "'.  This attribute is reserved for test verification output and is not publishable.  " + documentationRegistry.getDocumentationRecommendationFor("on this", "variant_attributes", "sec:verification_category"));
                }
            });
        }
    }
}

