/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.internal.component.local.model.ProjectComponentSelectorInternal;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class ResolutionBackedPublicationDependencyResolver
implements VariantDependencyResolver,
ComponentDependencyResolver {
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final AttributeDesugaring attributeDesugaring;
    private final ResolvedMappings mappings;

    public ResolutionBackedPublicationDependencyResolver(ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, AttributeDesugaring attributeDesugaring) {
        this.projectDependencyResolver = projectDependencyResolver;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributeDesugaring = attributeDesugaring;
        this.mappings = ResolutionBackedPublicationDependencyResolver.calculateMappings(rootComponent, rootVariant, projectDependencyResolver, moduleIdentifierFactory);
    }

    private static ResolvedMappings calculateMappings(ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        HashSet<ModuleDependencyKey> incompatibleModuleDeps = new HashSet<ModuleDependencyKey>();
        HashSet<ProjectDependencyKey> incompatibleProjectDeps = new HashSet<ProjectDependencyKey>();
        HashMap<ModuleIdentifier, ModuleVersionIdentifier> resolvedModuleComponents = new HashMap<ModuleIdentifier, ModuleVersionIdentifier>();
        HashMap<Path, ModuleVersionIdentifier> resolvedProjectComponents = new HashMap<Path, ModuleVersionIdentifier>();
        HashMap<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModuleVariants = new HashMap<ModuleDependencyKey, ModuleVersionIdentifier>();
        HashMap<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjectVariants = new HashMap<ProjectDependencyKey, ModuleVersionIdentifier>();
        ResolutionBackedPublicationDependencyResolver.visitFirstLevelEdges(rootComponent, rootVariant, edge -> {
            ComponentSelector requested = edge.getRequested();
            CoordinatePair coordinates = ResolutionBackedPublicationDependencyResolver.getResolvedCoordinates(edge.getResolvedVariant(), projectDependencyResolver, moduleIdentifierFactory);
            if (requested instanceof ModuleComponentSelector) {
                ModuleComponentSelector requestedModule = (ModuleComponentSelector)requested;
                ModuleVersionIdentifier existingComponent = resolvedModuleComponents.put(requestedModule.getModuleIdentifier(), coordinates.componentCoordinates);
                if (existingComponent != null && !existingComponent.equals(coordinates.componentCoordinates)) {
                    throw new GradleException("Expected all requested coordinates to resolve to the same component coordinates.");
                }
                ModuleDependencyKey key = new ModuleDependencyKey(requestedModule.getModuleIdentifier(), ModuleDependencyDetails.from(requested));
                if (incompatibleModuleDeps.contains(key)) {
                    return;
                }
                ModuleVersionIdentifier existingVariant = resolvedModuleVariants.put(key, coordinates.variantCoordinates);
                if (existingVariant != null && !existingVariant.equals(coordinates.variantCoordinates)) {
                    resolvedModuleVariants.remove(key);
                    incompatibleModuleDeps.add(key);
                }
            } else if (requested instanceof ProjectComponentSelector) {
                ProjectComponentSelectorInternal requestedProject = (ProjectComponentSelectorInternal)requested;
                ModuleVersionIdentifier existingComponent = resolvedProjectComponents.put(requestedProject.getIdentityPath(), coordinates.componentCoordinates);
                if (existingComponent != null && !existingComponent.equals(coordinates.componentCoordinates)) {
                    throw new GradleException("Expected all requested projects to resolve to the same component coordinates.");
                }
                ProjectDependencyKey key = new ProjectDependencyKey(requestedProject.getIdentityPath(), ModuleDependencyDetails.from(requested));
                if (incompatibleProjectDeps.contains(key)) {
                    return;
                }
                ModuleVersionIdentifier existingVariant = resolvedProjectVariants.put(key, coordinates.variantCoordinates);
                if (existingVariant != null && !existingVariant.equals(coordinates.variantCoordinates)) {
                    resolvedProjectVariants.remove(key);
                    incompatibleProjectDeps.add(key);
                }
            }
        });
        return new ResolvedMappings(resolvedModuleComponents, resolvedProjectComponents, resolvedModuleVariants, resolvedProjectVariants, incompatibleModuleDeps, incompatibleProjectDeps);
    }

    private static void visitFirstLevelEdges(ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, Consumer<ResolvedDependencyResult> visitor) {
        List rootEdges = rootComponent.getDependenciesForVariant(rootVariant);
        for (DependencyResult dependencyResult : rootEdges) {
            if (!(dependencyResult instanceof ResolvedDependencyResult)) {
                UnresolvedDependencyResult unresolved = (UnresolvedDependencyResult)dependencyResult;
                throw new GradleException("Could not map coordinates for " + unresolved.getAttempted().getDisplayName() + ".", unresolved.getFailure());
            }
            if (dependencyResult.isConstraint()) continue;
            visitor.accept((ResolvedDependencyResult)dependencyResult);
        }
    }

    private static CoordinatePair getResolvedCoordinates(ResolvedVariantResult variant, ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        ComponentIdentifier componentId = variant.getOwner();
        if (componentId instanceof ProjectComponentIdentifier) {
            return ResolutionBackedPublicationDependencyResolver.getProjectCoordinates(variant, (ProjectComponentIdentifierInternal)componentId, projectDependencyResolver);
        }
        if (componentId instanceof ModuleComponentIdentifier) {
            return ResolutionBackedPublicationDependencyResolver.getModuleCoordinates(variant, (ModuleComponentIdentifier)componentId, moduleIdentifierFactory);
        }
        throw new UnsupportedOperationException("Unexpected component identifier type: " + componentId);
    }

    private static CoordinatePair getModuleCoordinates(ResolvedVariantResult variant, ModuleComponentIdentifier componentId, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        ModuleVersionIdentifier componentCoordinates = moduleIdentifierFactory.moduleWithVersion(componentId.getModuleIdentifier(), componentId.getVersion());
        ModuleVersionIdentifier variantCoordinates = ResolutionBackedPublicationDependencyResolver.getExternalCoordinates(variant, moduleIdentifierFactory);
        return new CoordinatePair(componentCoordinates, variantCoordinates != null ? variantCoordinates : componentCoordinates);
    }

    private static @Nullable ModuleVersionIdentifier getExternalCoordinates(ResolvedVariantResult variant, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        ResolvedVariantResult externalVariant = variant.getExternalVariant().orElse(null);
        if (externalVariant != null) {
            ComponentIdentifier owningComponent = externalVariant.getOwner();
            if (owningComponent instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)owningComponent;
                return moduleIdentifierFactory.moduleWithVersion(moduleComponentId.getModuleIdentifier(), moduleComponentId.getVersion());
            }
            throw new GradleException("Expected owning component of module component to be a module component: " + owningComponent);
        }
        return null;
    }

    private static CoordinatePair getProjectCoordinates(ResolvedVariantResult variant, ProjectComponentIdentifierInternal componentId, ProjectDependencyPublicationResolver projectDependencyResolver) {
        String variantName;
        Path identityPath = componentId.getIdentityPath();
        ModuleVersionIdentifier variantCoordinates = (ModuleVersionIdentifier)projectDependencyResolver.resolveVariant(ModuleVersionIdentifier.class, identityPath, variantName = variant.getDisplayName());
        if (variantCoordinates == null) {
            throw new InvalidUserDataException(String.format("Could not resolve coordinates for variant '%s' of project '%s'.", variantName, identityPath));
        }
        ModuleVersionIdentifier componentCoordinates = (ModuleVersionIdentifier)projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath);
        return new CoordinatePair(componentCoordinates, variantCoordinates);
    }

    @Override
    public @Nullable ResolvedCoordinates resolveVariantCoordinates(ExternalDependency dependency, VariantWarningCollector warnings) {
        ModuleIdentifier module = this.moduleIdentifierFactory.module(dependency.getGroup(), dependency.getName());
        ModuleDependencyKey key = new ModuleDependencyKey(module, ModuleDependencyDetails.from((ModuleDependency)dependency, this.attributeDesugaring));
        ModuleVersionIdentifier resolved = this.mappings.resolvedModuleVariants.get(key);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        if (this.mappings.incompatibleModules.contains(key)) {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for dependency '%s' since multiple dependencies ambiguously map to different resolved coordinates.", module));
        } else {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for dependency '%s' since the resolved graph does not contain the requested module.", module));
        }
        return this.resolveModuleComponentCoordinates(module);
    }

    @Override
    public ResolvedCoordinates resolveVariantCoordinates(ProjectDependency dependency, VariantWarningCollector warnings) {
        Path identityPath = ((ProjectDependencyInternal)dependency).getTargetProjectIdentity().getBuildTreePath();
        ProjectDependencyKey key = new ProjectDependencyKey(identityPath, ModuleDependencyDetails.from((ModuleDependency)dependency, this.attributeDesugaring));
        ModuleVersionIdentifier resolved = this.mappings.resolvedProjectVariants.get(key);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        if (this.mappings.incompatibleProjects.contains(key)) {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for Project dependency '%s' since multiple dependencies ambiguously map to different resolved coordinates.", identityPath));
        } else {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for Project dependency '%s' since the resolved graph does not contain the requested project.", identityPath));
        }
        return this.resolveComponentCoordinates(dependency);
    }

    @Override
    public @Nullable ResolvedCoordinates resolveComponentCoordinates(ExternalDependency dependency) {
        ModuleIdentifier module = this.moduleIdentifierFactory.module(dependency.getGroup(), dependency.getName());
        return this.resolveModuleComponentCoordinates(module);
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(ProjectDependency dependency) {
        Path identityPath = ((ProjectDependencyInternal)dependency).getTargetProjectIdentity().getBuildTreePath();
        ModuleVersionIdentifier resolved = this.mappings.resolvedProjectComponents.get(identityPath);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        return ResolvedCoordinates.create((ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath));
    }

    @Override
    public @Nullable ResolvedCoordinates resolveComponentCoordinates(DependencyConstraint dependency) {
        assert (!(dependency instanceof DefaultProjectDependencyConstraint));
        ModuleIdentifier module = this.moduleIdentifierFactory.module(dependency.getGroup(), dependency.getName());
        return this.resolveModuleComponentCoordinates(module);
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(DefaultProjectDependencyConstraint dependency) {
        return this.resolveComponentCoordinates(dependency.getProjectDependency());
    }

    private @Nullable ResolvedCoordinates resolveModuleComponentCoordinates(ModuleIdentifier module) {
        ModuleVersionIdentifier resolved = this.mappings.resolvedModuleComponents.get(module);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        return null;
    }

    private static class ResolvedMappings {
        final Map<ModuleIdentifier, ModuleVersionIdentifier> resolvedModuleComponents;
        final Map<Path, ModuleVersionIdentifier> resolvedProjectComponents;
        final Map<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModuleVariants;
        final Map<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjectVariants;
        final Set<ModuleDependencyKey> incompatibleModules;
        final Set<ProjectDependencyKey> incompatibleProjects;

        ResolvedMappings(Map<ModuleIdentifier, ModuleVersionIdentifier> resolvedModuleComponents, Map<Path, ModuleVersionIdentifier> resolvedProjectComponents, Map<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModuleVariants, Map<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjectVariants, Set<ModuleDependencyKey> incompatibleModules, Set<ProjectDependencyKey> incompatibleProjects) {
            this.resolvedModuleComponents = resolvedModuleComponents;
            this.resolvedProjectComponents = resolvedProjectComponents;
            this.resolvedModuleVariants = resolvedModuleVariants;
            this.resolvedProjectVariants = resolvedProjectVariants;
            this.incompatibleModules = incompatibleModules;
            this.incompatibleProjects = incompatibleProjects;
        }
    }

    private static class CoordinatePair {
        final ModuleVersionIdentifier componentCoordinates;
        final ModuleVersionIdentifier variantCoordinates;

        private CoordinatePair(ModuleVersionIdentifier componentCoordinates, ModuleVersionIdentifier variantCoordinates) {
            this.componentCoordinates = componentCoordinates;
            this.variantCoordinates = variantCoordinates;
        }
    }

    private static class ModuleDependencyKey {
        private final ModuleIdentifier module;
        private final ModuleDependencyDetails details;

        public ModuleDependencyKey(ModuleIdentifier module, ModuleDependencyDetails details) {
            this.module = module;
            this.details = details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyKey that = (ModuleDependencyKey)o;
            return Objects.equals(this.module, that.module) && Objects.equals(this.details, that.details);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.details);
        }
    }

    private static class ModuleDependencyDetails {
        final AttributeContainer requestAttributes;
        final Set<CapabilitySelector> capabilitySelectors;

        public ModuleDependencyDetails(AttributeContainer requestAttributes, Set<CapabilitySelector> capabilitySelectors) {
            this.requestAttributes = requestAttributes;
            this.capabilitySelectors = capabilitySelectors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyDetails that = (ModuleDependencyDetails)o;
            return Objects.equals(this.requestAttributes, that.requestAttributes) && Objects.equals(this.capabilitySelectors, that.capabilitySelectors);
        }

        public int hashCode() {
            return Objects.hash(this.requestAttributes, this.capabilitySelectors);
        }

        public static ModuleDependencyDetails from(ModuleDependency dependency, AttributeDesugaring attributeDesugaring) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)dependency.getAttributes()).asImmutable();
            return new ModuleDependencyDetails((AttributeContainer)attributeDesugaring.desugar(attributes), dependency.getCapabilitySelectors());
        }

        public static ModuleDependencyDetails from(ComponentSelector componentSelector) {
            return new ModuleDependencyDetails(componentSelector.getAttributes(), componentSelector.getCapabilitySelectors());
        }
    }

    private static class ProjectDependencyKey {
        private final Path identityPath;
        private final ModuleDependencyDetails details;

        public ProjectDependencyKey(Path identityPath, ModuleDependencyDetails details) {
            this.identityPath = identityPath;
            this.details = details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectDependencyKey that = (ProjectDependencyKey)o;
            return Objects.equals(this.identityPath, that.identityPath) && Objects.equals(this.details, that.details);
        }

        public int hashCode() {
            return Objects.hash(this.identityPath, this.details);
        }
    }
}

