/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io.functors;

import java.util.AbstractMap;
import java.util.Collection;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface Invoker<ARG, RET> {
    public RET invoke(ARG var1) throws Throwable;

    public static <ARG> Invoker<ARG, Void> wrapAll(Collection<? extends Invoker<? super ARG, ?>> invokers) {
        return arg -> {
            Invoker.invokeAll(arg, invokers);
            return null;
        };
    }

    public static <ARG> void invokeAll(ARG arg, Collection<? extends Invoker<? super ARG, ?>> invokers) throws Throwable {
        if (GenericUtils.isEmpty(invokers)) {
            return;
        }
        Throwable err = null;
        for (Invoker<ARG, ?> i : invokers) {
            if (i == null) continue;
            try {
                i.invoke(arg);
            }
            catch (Throwable t) {
                err = ExceptionUtils.accumulateException(err, t);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    public static <ARG> Invoker<ARG, Void> wrapFirst(Collection<? extends Invoker<? super ARG, ?>> invokers) {
        return arg -> {
            AbstractMap.SimpleImmutableEntry<Invoker<Object, ?>, Throwable> result = Invoker.invokeTillFirstFailure(arg, invokers);
            if (result != null) {
                throw (Throwable)result.getValue();
            }
            return null;
        };
    }

    public static <ARG> AbstractMap.SimpleImmutableEntry<Invoker<? super ARG, ?>, Throwable> invokeTillFirstFailure(ARG arg, Collection<? extends Invoker<? super ARG, ?>> invokers) {
        if (GenericUtils.isEmpty(invokers)) {
            return null;
        }
        for (Invoker<ARG, ?> i : invokers) {
            if (i == null) continue;
            try {
                i.invoke(arg);
            }
            catch (Throwable t) {
                return new AbstractMap.SimpleImmutableEntry(i, t);
            }
        }
        return null;
    }
}

