/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.m12n;

import groovy.lang.GroovyRuntimeException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.runtime.m12n.SimpleExtensionModule;

public class MetaInfExtensionModule
extends SimpleExtensionModule {
    private final List<Class> instanceExtensionClasses;
    private final List<Class> staticExtensionClasses;
    public static final String MODULE_INSTANCE_CLASSES_KEY = "extensionClasses";
    public static final String MODULE_STATIC_CLASSES_KEY = "staticExtensionClasses";

    @Override
    public List<Class> getInstanceMethodsExtensionClasses() {
        return this.instanceExtensionClasses;
    }

    @Override
    public List<Class> getStaticMethodsExtensionClasses() {
        return this.staticExtensionClasses;
    }

    private MetaInfExtensionModule(String moduleName, String moduleVersion, List<Class> instanceExtensionClasses, List<Class> staticExtensionClasses) {
        super(moduleName, moduleVersion);
        this.instanceExtensionClasses = instanceExtensionClasses;
        this.staticExtensionClasses = staticExtensionClasses;
    }

    public static MetaInfExtensionModule newModule(Properties properties, ClassLoader loader) {
        String name = properties.getProperty("moduleName");
        if (name == null) {
            throw new GroovyRuntimeException("Module file has not set the module name using key: moduleName");
        }
        String version = properties.getProperty("moduleVersion");
        if (version == null) {
            throw new GroovyRuntimeException("Module file has not set the module version using key: moduleVersion");
        }
        Function<String, Class> load = extensionClass -> {
            try {
                extensionClass = extensionClass.trim();
                if (!extensionClass.isEmpty()) {
                    return loader.loadClass((String)extensionClass);
                }
            }
            catch (ClassNotFoundException | LinkageError | RuntimeException error) {
                Logger logger = Logger.getLogger(MetaInfExtensionModule.class.getName());
                logger.log(Level.WARNING, "Module [" + name + "] - Unable to load extension class: " + extensionClass, error);
            }
            return null;
        };
        String[] objectExtensionClasses = properties.getProperty(MODULE_INSTANCE_CLASSES_KEY, "").trim().split("[,; ]");
        String[] staticExtensionClasses = properties.getProperty(MODULE_STATIC_CLASSES_KEY, "").trim().split("[,; ]");
        List<Class> objectClasses = Stream.of(objectExtensionClasses).map(load).filter(Objects::nonNull).collect(Collectors.toList());
        List<Class> staticClasses = Stream.of(staticExtensionClasses).map(load).filter(Objects::nonNull).collect(Collectors.toList());
        return new MetaInfExtensionModule(name, version, objectClasses, staticClasses);
    }
}

