/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.util.List;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractMacroFunction;

public class ReturnParameterMacroFunction
extends AbstractMacroFunction {
    private final int parameterToReturn;

    public ReturnParameterMacroFunction(String name, int parameters, int parameterToReturn) {
        super(name, parameters);
        this.parameterToReturn = parameterToReturn;
    }

    public int getParameterToReturn() {
        return this.parameterToReturn;
    }

    @Override
    protected String getBody() {
        return "=> return parameter " + this.parameterToReturn;
    }

    public Expression evaluate(List<Expression> arguments) {
        return arguments.get(this.parameterToReturn).asMacroExpansion();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ReturnParameterMacroFunction other = (ReturnParameterMacroFunction)obj;
        return this.parameterToReturn == other.parameterToReturn;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.parameterToReturn * 31;
    }
}

