/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;

public class ImporterTopLevel
extends TopLevel {
    private static final long serialVersionUID = -9095380847465315412L;
    private static final Object IMPORTER_TAG = "Importer";
    private static final int Id_constructor = 1;
    private static final int Id_importClass = 2;
    private static final int Id_importPackage = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final String AKEY = "importedPackages";
    private boolean topScopeFlag;

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context context) {
        this(context, false);
    }

    public ImporterTopLevel(Context context, boolean bl) {
        this.initStandardObjects(context, bl);
    }

    @Override
    public String getClassName() {
        return this.topScopeFlag ? "global" : "JavaImporter";
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        importerTopLevel.exportAsJSClass(3, scriptable, bl);
    }

    public void initStandardObjects(Context context, boolean bl) {
        context.initStandardObjects(this, bl);
        this.topScopeFlag = true;
        IdFunctionObject idFunctionObject = this.exportAsJSClass(3, this, false);
        if (bl) {
            idFunctionObject.sealObject();
        }
        this.delete("constructor");
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return super.has(string, scriptable) || this.getPackageProperty(string, scriptable) != NOT_FOUND;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        object = this.getPackageProperty(string, scriptable);
        return object;
    }

    private Object getPackageProperty(String string, Scriptable scriptable) {
        Object[] objectArray;
        Object object = NOT_FOUND;
        Scriptable scriptable2 = scriptable;
        if (this.topScopeFlag) {
            scriptable2 = ScriptableObject.getTopLevelScope(scriptable2);
        }
        if ((objectArray = ImporterTopLevel.getNativeJavaPackages(scriptable2)) == null) {
            return object;
        }
        for (Object object2 : objectArray) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)object2;
            Object object3 = nativeJavaPackage.getPkgProperty(string, scriptable, false);
            if (object3 == null || object3 instanceof NativeJavaPackage) continue;
            if (object == NOT_FOUND) {
                object = object3;
                continue;
            }
            throw Context.reportRuntimeErrorById("msg.ambig.import", object.toString(), object3.toString());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getNativeJavaPackages(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        synchronized (scriptable2) {
            ScriptableObject scriptableObject;
            ObjArray objArray;
            if (scriptable instanceof ScriptableObject && (objArray = (ObjArray)(scriptableObject = (ScriptableObject)scriptable).getAssociatedValue(AKEY)) != null) {
                return objArray.toArray();
            }
        }
        return null;
    }

    @Deprecated
    public void importPackage(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        ImporterTopLevel.js_importPackage(this, objectArray);
    }

    private Object js_construct(Scriptable scriptable, Object[] objectArray) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel();
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof NativeJavaClass) {
                ImporterTopLevel.importClass(importerTopLevel, (NativeJavaClass)object);
                continue;
            }
            if (object instanceof NativeJavaPackage) {
                ImporterTopLevel.importPackage(importerTopLevel, (NativeJavaPackage)object);
                continue;
            }
            throw Context.reportRuntimeErrorById("msg.not.class.not.pkg", Context.toString(object));
        }
        importerTopLevel.setParentScope(scriptable);
        importerTopLevel.setPrototype(this);
        return importerTopLevel;
    }

    private static Object js_importClass(Scriptable scriptable, Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaClass)) {
                throw Context.reportRuntimeErrorById("msg.not.class", Context.toString(object));
            }
            ImporterTopLevel.importClass(scriptable, (NativeJavaClass)object);
        }
        return Undefined.instance;
    }

    private static Object js_importPackage(ScriptableObject scriptableObject, Object[] objectArray) {
        for (int i = 0; i != objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeErrorById("msg.not.pkg", Context.toString(object));
            }
            ImporterTopLevel.importPackage(scriptableObject, (NativeJavaPackage)object);
        }
        return Undefined.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importPackage(ScriptableObject scriptableObject, NativeJavaPackage nativeJavaPackage) {
        if (nativeJavaPackage == null) {
            return;
        }
        ScriptableObject scriptableObject2 = scriptableObject;
        synchronized (scriptableObject2) {
            ObjArray objArray = (ObjArray)scriptableObject.getAssociatedValue(AKEY);
            if (objArray == null) {
                objArray = new ObjArray();
                scriptableObject.associateValue(AKEY, objArray);
            }
            for (int i = 0; i != objArray.size(); ++i) {
                if (!nativeJavaPackage.equals(objArray.get(i))) continue;
                return;
            }
            objArray.add(nativeJavaPackage);
        }
    }

    private static void importClass(Scriptable scriptable, NativeJavaClass nativeJavaClass) {
        String string = nativeJavaClass.getClassObject().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        Object object = scriptable.get(string2, scriptable);
        if (object != NOT_FOUND && object != nativeJavaClass) {
            throw Context.reportRuntimeErrorById("msg.prop.defined", string2);
        }
        scriptable.put(string2, scriptable, (Object)nativeJavaClass);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "importClass";
                break;
            }
            case 3: {
                n2 = 1;
                string = "importPackage";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(IMPORTER_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(IMPORTER_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.js_construct(scriptable, objectArray);
            }
            case 2: {
                return ImporterTopLevel.js_importClass(this.realScope(scriptable, scriptable2, idFunctionObject), objectArray);
            }
            case 3: {
                return ImporterTopLevel.js_importPackage(this.realScope(scriptable, scriptable2, idFunctionObject), objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private ScriptableObject realScope(Scriptable scriptable, Scriptable scriptable2, IdFunctionObject idFunctionObject) {
        if (this.topScopeFlag) {
            scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        }
        return ImporterTopLevel.ensureType(scriptable2, ScriptableObject.class, idFunctionObject);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "importClass": {
                n = 2;
                break;
            }
            case "importPackage": {
                n = 3;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

