/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.LangCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.jclf.text.TokenParser;

class SelectorSerializer {
    private final SheetContext parentSheet;

    public SelectorSerializer(SheetContext sheetContext) {
        this.parentSheet = sheetContext;
    }

    private SheetContext getSheetContext() {
        return this.parentSheet;
    }

    String selectorText(Selector selector, boolean bl) {
        return this.selectorText(selector, bl, false);
    }

    private String selectorText(Selector selector, boolean bl, boolean bl2) {
        switch (selector.getSelectorType()) {
            case UNIVERSAL: {
                return bl ? "" : "*";
            }
            case ELEMENT: {
                ElementSelector elementSelector = (ElementSelector)selector;
                String string = elementSelector.getLocalName();
                String string2 = elementSelector.getNamespaceURI();
                if (string != null) {
                    string = ParseHelper.escape(string, false, false);
                }
                if (string2 != null) {
                    if (string2.length() != 0) {
                        String string3 = this.getSheetContext().getNamespacePrefix(elementSelector.getNamespaceURI());
                        if (string3 == null) {
                            throw new IllegalStateException("Unknown ns prefix for URI " + elementSelector.getNamespaceURI());
                        }
                        if (string3.length() != 0) {
                            return string3 + "|" + string;
                        }
                        return string;
                    }
                    return "|" + string;
                }
                SheetContext sheetContext = this.getSheetContext();
                if (sheetContext != null && sheetContext.hasDefaultNamespace()) {
                    return "*|" + string;
                }
                return string != null ? string : (bl ? "" : "*");
            }
            case CHILD: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                Selector selector2 = combinatorSelector.getSelector();
                String string = !bl2 || selector2.getSelectorType() != Selector.SelectorType.UNIVERSAL ? this.selectorText(selector2, false, bl2) : "";
                String string4 = this.selectorText(combinatorSelector.getSecondSelector(), false, bl2);
                StringBuilder stringBuilder = new StringBuilder(string.length() + string4.length() + 3);
                stringBuilder.append(string);
                stringBuilder.append('>');
                stringBuilder.append(string4);
                return stringBuilder.toString();
            }
            case CONDITIONAL: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                return this.conditionalSelectorText(conditionalSelector.getCondition(), conditionalSelector.getSimpleSelector());
            }
            case DESCENDANT: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                Selector selector3 = combinatorSelector.getSelector();
                String string = this.selectorText(selector3, false, bl2);
                String string5 = this.selectorText(combinatorSelector.getSecondSelector(), false, bl2);
                StringBuilder stringBuilder = new StringBuilder(string.length() + string5.length() + 1);
                stringBuilder.append(string);
                stringBuilder.append(' ');
                stringBuilder.append(string5);
                return stringBuilder.toString();
            }
            case DIRECT_ADJACENT: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                return this.selectorText(combinatorSelector.getSelector(), bl, bl2) + '+' + this.selectorText(combinatorSelector.getSecondSelector(), false, bl2);
            }
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                return this.selectorText(combinatorSelector.getSelector(), bl, bl2) + "~" + this.selectorText(combinatorSelector.getSecondSelector(), false, bl2);
            }
            case COLUMN_COMBINATOR: {
                CombinatorSelector combinatorSelector = (CombinatorSelector)selector;
                return this.selectorText(combinatorSelector.getSelector(), bl, bl2) + "||" + this.selectorText(combinatorSelector.getSecondSelector(), false, bl2);
            }
            case SCOPE_MARKER: {
                return "";
            }
        }
        return null;
    }

    private String conditionalSelectorText(Condition condition, SimpleSelector simpleSelector) {
        switch (condition.getConditionType()) {
            case CLASS: {
                return this.classText((AttributeCondition)condition, simpleSelector);
            }
            case ID: {
                String string = ((AttributeCondition)condition).getValue();
                StringBuilder stringBuilder = new StringBuilder(string.length() + 1);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, stringBuilder);
                }
                return stringBuilder.append('#').append(ParseHelper.escape(string, false, false)).toString();
            }
            case ATTRIBUTE: {
                return this.attributeText((AttributeCondition)condition, simpleSelector);
            }
            case BEGINS_ATTRIBUTE: {
                return this.attributeBeginsText((AttributeCondition)condition, simpleSelector);
            }
            case BEGIN_HYPHEN_ATTRIBUTE: {
                return this.attributeBeginHyphenText((AttributeCondition)condition, simpleSelector);
            }
            case ENDS_ATTRIBUTE: {
                return this.attributeEndsText((AttributeCondition)condition, simpleSelector);
            }
            case SUBSTRING_ATTRIBUTE: {
                return this.attributeSubstringText((AttributeCondition)condition, simpleSelector);
            }
            case LANG: {
                return this.langText((LangCondition)condition, simpleSelector);
            }
            case ONE_OF_ATTRIBUTE: {
                return this.attributeOneOfText((AttributeCondition)condition, simpleSelector);
            }
            case ONLY_CHILD: {
                StringBuilder stringBuilder = new StringBuilder(16);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, stringBuilder);
                }
                return stringBuilder.append(":only-child").toString();
            }
            case ONLY_TYPE: {
                StringBuilder stringBuilder = new StringBuilder(16);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, stringBuilder);
                }
                return stringBuilder.append(":only-of-type").toString();
            }
            case POSITIONAL: {
                StringBuilder stringBuilder = new StringBuilder(50);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, stringBuilder);
                }
                PositionalCondition positionalCondition = (PositionalCondition)condition;
                stringBuilder.append(':');
                if (positionalCondition.isOfType()) {
                    this.appendPositionalOfType(positionalCondition, stringBuilder);
                } else {
                    this.appendPositional(positionalCondition, stringBuilder);
                }
                return stringBuilder.toString();
            }
            case PSEUDO_CLASS: {
                return this.pseudoClassText((PseudoCondition)condition, simpleSelector);
            }
            case PSEUDO_ELEMENT: {
                return this.pseudoElementText((PseudoCondition)condition, simpleSelector);
            }
            case AND: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                return this.conditionalSelectorText(combinatorCondition.getFirstCondition(), simpleSelector) + this.conditionalSelectorText(combinatorCondition.getSecondCondition(), null);
            }
            case SELECTOR_ARGUMENT: {
                return this.selectorArgumentText((ArgumentCondition)condition, simpleSelector);
            }
        }
        return null;
    }

    private void appendSimpleSelector(SimpleSelector simpleSelector, StringBuilder stringBuilder) {
        stringBuilder.append(this.selectorText(simpleSelector, true));
    }

    private String classText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(16);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append(".").append(ParseHelper.escape(attributeCondition.getValue(), false, false));
        return stringBuilder.toString();
    }

    private String pseudoClassText(PseudoCondition pseudoCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(24);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append(':');
        String string = pseudoCondition.getName();
        String string2 = pseudoCondition.getArgument();
        if (string == null) {
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(string);
            if (string2 != null) {
                stringBuilder.append('(');
                stringBuilder.append(string2);
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    private String attributeText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(32);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        if ((string = attributeCondition.getValue()) != null) {
            stringBuilder.append('[');
            this.serializeAttributeQName(attributeCondition, stringBuilder);
            stringBuilder.append('=');
            this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
            this.attributeSelectorEnd(attributeCondition, stringBuilder);
        } else {
            stringBuilder.append('[');
            this.serializeAttributeQName(attributeCondition, stringBuilder);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private String attributeBeginsText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append('[');
        this.serializeAttributeQName(attributeCondition, stringBuilder);
        stringBuilder.append("^=");
        this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
        this.attributeSelectorEnd(attributeCondition, stringBuilder);
        return stringBuilder.toString();
    }

    private String attributeBeginHyphenText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append('[');
        this.serializeAttributeQName(attributeCondition, stringBuilder);
        stringBuilder.append("|=");
        this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
        this.attributeSelectorEnd(attributeCondition, stringBuilder);
        return stringBuilder.toString();
    }

    private String attributeEndsText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append('[');
        this.serializeAttributeQName(attributeCondition, stringBuilder);
        stringBuilder.append("$=");
        this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
        this.attributeSelectorEnd(attributeCondition, stringBuilder);
        return stringBuilder.toString();
    }

    private String attributeSubstringText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append('[');
        this.serializeAttributeQName(attributeCondition, stringBuilder);
        stringBuilder.append("*=");
        this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
        this.attributeSelectorEnd(attributeCondition, stringBuilder);
        return stringBuilder.toString();
    }

    private String attributeOneOfText(AttributeCondition attributeCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append('[');
        this.serializeAttributeQName(attributeCondition, stringBuilder);
        stringBuilder.append("~=");
        this.quoteAttributeValue(attributeCondition.getValue(), stringBuilder);
        this.attributeSelectorEnd(attributeCondition, stringBuilder);
        return stringBuilder.toString();
    }

    private void serializeAttributeQName(AttributeCondition attributeCondition, StringBuilder stringBuilder) {
        String string;
        String string2 = attributeCondition.getNamespaceURI();
        if (string2 != null) {
            if (string2.length() != 0) {
                string = this.getSheetContext().getNamespacePrefix(string2);
                if (string == null) {
                    throw new IllegalStateException("Unknown ns prefix for URI " + string2);
                }
                if (string.length() != 0) {
                    stringBuilder.append(string).append('|');
                }
            } else {
                stringBuilder.append('|');
            }
        }
        string = ParseHelper.escape(attributeCondition.getLocalName(), false, false);
        stringBuilder.append(string);
    }

    private void quoteAttributeValue(String string, StringBuilder stringBuilder) {
        char c = this.quoteChar(true);
        stringBuilder.append(ParseHelper.quote(string, c));
    }

    private void attributeSelectorEnd(AttributeCondition attributeCondition, StringBuilder stringBuilder) {
        if (attributeCondition.hasFlag(AttributeCondition.Flag.CASE_I)) {
            stringBuilder.append(" i");
        } else if (attributeCondition.hasFlag(AttributeCondition.Flag.CASE_S)) {
            stringBuilder.append(" s");
        }
        stringBuilder.append(']');
    }

    private String langText(LangCondition langCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append(":lang(");
        String string = langCondition.getLang();
        TokenParser tokenParser = new TokenParser(string, ", ", "\"'");
        String string2 = tokenParser.next();
        int n = string.indexOf(44) + 1;
        stringBuilder.append(this.escapeLang(string2, string, n));
        while (tokenParser.hasNext()) {
            string2 = tokenParser.next();
            n = string.indexOf(44, n) + 1;
            stringBuilder.append(',').append(this.escapeLang(string2, string, n));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String escapeLang(String string, String string2, int n) {
        boolean bl;
        int n2 = string2.indexOf(44, n) + 1;
        int n3 = string2.indexOf(34, n);
        int n4 = string2.indexOf(39, n);
        boolean bl2 = bl = n3 == -1 || n3 > n2;
        if (string.indexOf(32) != -1) {
            char c = this.quoteChar(bl);
            string = ParseHelper.quote(string, c);
        } else {
            CharSequence charSequence = ParseHelper.escapeCssCharsAndFirstChar(string);
            if (charSequence != string) {
                boolean bl3;
                boolean bl4 = bl3 = n4 == -1 || n4 > n2;
                if (charSequence.length() < string.length() + 2 && bl && bl3) {
                    string = charSequence.toString();
                } else {
                    char c = this.quoteChar(bl);
                    string = ParseHelper.quote(string, c);
                }
            }
        }
        return string;
    }

    private char quoteChar(boolean bl) {
        SheetContext sheetContext = this.getSheetContext();
        int n = sheetContext != null ? (sheetContext.hasFactoryFlag((short)2) ? 34 : (sheetContext.hasFactoryFlag((short)1) ? 39 : (bl ? 39 : 34))) : (bl ? 39 : 34);
        return (char)n;
    }

    private String pseudoElementText(PseudoCondition pseudoCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(16);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        return stringBuilder.append(':').append(':').append(pseudoCondition.getName()).toString();
    }

    private String selectorArgumentText(ArgumentCondition argumentCondition, SimpleSelector simpleSelector) {
        StringBuilder stringBuilder = new StringBuilder(96);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, stringBuilder);
        }
        stringBuilder.append(':').append(argumentCondition.getName()).append("(");
        this.selectorListText(stringBuilder, argumentCondition.getSelectors(), false, true);
        return stringBuilder.append(')').toString();
    }

    private void appendPositional(PositionalCondition positionalCondition, StringBuilder stringBuilder) {
        int n = positionalCondition.getFactor();
        int n2 = positionalCondition.getOffset();
        SelectorList selectorList = positionalCondition.getOfList();
        boolean bl = positionalCondition.isForwardCondition();
        if (n == 0) {
            if (n2 == 1 && selectorList == null && !positionalCondition.hasArgument()) {
                if (bl) {
                    stringBuilder.append("first-child");
                } else {
                    stringBuilder.append("last-child");
                }
            } else {
                if (bl) {
                    stringBuilder.append("nth-child(");
                } else {
                    stringBuilder.append("nth-last-child(");
                }
                stringBuilder.append(n2);
                if (!SelectorSerializer.isUniversalSelectorList(selectorList)) {
                    stringBuilder.append(" of ");
                    this.selectorListText(stringBuilder, selectorList, true, false);
                }
                stringBuilder.append(')');
            }
        } else {
            if (bl) {
                stringBuilder.append("nth-child(");
            } else {
                stringBuilder.append("nth-last-child(");
            }
            this.appendAnB(n, n2, positionalCondition.hasKeyword(), stringBuilder);
            if (!SelectorSerializer.isUniversalSelectorList(selectorList)) {
                stringBuilder.append(" of ").append(selectorList.toString());
            }
            stringBuilder.append(')');
        }
    }

    private void appendPositionalOfType(PositionalCondition positionalCondition, StringBuilder stringBuilder) {
        int n = positionalCondition.getFactor();
        int n2 = positionalCondition.getOffset();
        SelectorList selectorList = positionalCondition.getOfList();
        boolean bl = positionalCondition.isForwardCondition();
        if (n == 0) {
            if (n2 == 1 && selectorList == null && !positionalCondition.hasArgument()) {
                if (bl) {
                    stringBuilder.append("first-of-type");
                } else {
                    stringBuilder.append("last-of-type");
                }
            } else {
                if (bl) {
                    stringBuilder.append("nth-of-type(");
                } else {
                    stringBuilder.append("nth-last-of-type(");
                }
                stringBuilder.append(n2).append(')');
            }
        } else {
            if (bl) {
                stringBuilder.append("nth-of-type(");
            } else {
                stringBuilder.append("nth-last-of-type(");
            }
            this.appendAnB(n, n2, positionalCondition.hasKeyword(), stringBuilder);
            stringBuilder.append(')');
        }
    }

    private void appendAnB(int n, int n2, boolean bl, StringBuilder stringBuilder) {
        if (bl && n == 2) {
            if (n2 == 0) {
                stringBuilder.append("even");
            } else {
                stringBuilder.append("odd");
            }
            return;
        }
        if (n == -1) {
            stringBuilder.append('-');
        } else if (n != 1) {
            stringBuilder.append(n);
        }
        stringBuilder.append('n');
        if (n2 > 0) {
            stringBuilder.append('+');
            stringBuilder.append(n2);
        } else if (n2 != 0) {
            stringBuilder.append(n2);
        }
    }

    void selectorListText(StringBuilder stringBuilder, SelectorList selectorList, boolean bl, boolean bl2) {
        stringBuilder.append(this.selectorText(selectorList.item(0), bl, bl2));
        for (int i = 1; i < selectorList.getLength(); ++i) {
            stringBuilder.append(',').append(this.selectorText(selectorList.item(i), bl, bl2));
        }
    }

    private static boolean isUniversalSelectorList(SelectorList selectorList) {
        if (selectorList == null) {
            return true;
        }
        for (int i = 0; i < selectorList.getLength(); ++i) {
            if (selectorList.item(i).getSelectorType() != Selector.SelectorType.UNIVERSAL) continue;
            return true;
        }
        return false;
    }
}

