/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSRuleList;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.doc.xml.dtd.EntityFinder;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class DOMWriter {
    private String indentingUnit = "  ";
    private final StringBuilder indentString = new StringBuilder(48);
    private HashMap<Integer, String> entityMap = null;
    private EntityResolver2 resolver = null;
    private CSSStyleSheet<?> uaSheet;
    private HashMap<String, String> displayMap = null;
    private Node rootNode = null;

    public DOMWriter() {
    }

    public DOMWriter(CSSStyleSheet<? extends CSSRule> cSSStyleSheet) {
        this.uaSheet = cSSStyleSheet;
    }

    public int setEntityCodepoints(DocumentType documentType, int[] nArray) throws SAXException, IOException {
        if (documentType == null || nArray == null) {
            throw new NullPointerException();
        }
        int n = 0;
        if (this.entityMap == null) {
            this.entityMap = new HashMap(nArray.length + 2);
            this.entityMap.put(60, "lt");
            this.entityMap.put(62, "gt");
        }
        Object object = nArray;
        int n2 = ((int[])object).length;
        for (int i = 0; i < n2; ++i) {
            int n3 = object[i];
            this.entityMap.putIfAbsent(n3, null);
        }
        if (this.resolver == null) {
            this.resolver = new DefaultEntityResolver();
        }
        if ((object = (Object)this.resolver.resolveEntity(documentType.getName(), documentType.getPublicId(), documentType.getBaseURI(), documentType.getSystemId())) != null) {
            EntityFinder entityFinder = new EntityFinder(this.resolver);
            Reader reader = ((InputSource)object).getCharacterStream();
            n = entityFinder.findEntities(this.entityMap, reader);
            reader.close();
        }
        return n;
    }

    public void setEntityResolver(EntityResolver2 entityResolver2) {
        this.resolver = entityResolver2;
    }

    public void setIndentingUnit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative count");
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        this.indentingUnit = stringBuilder.toString();
    }

    public static void writeTree(Node node, SimpleWriter simpleWriter) throws DOMException, IOException {
        DOMWriter dOMWriter = new DOMWriter();
        dOMWriter.writeNode(node, simpleWriter);
    }

    public String serializeToString(Node node) throws DOMException {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(512);
        try {
            this.writeNode(node, (SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return bufferSimpleWriter.toString();
    }

    public void writeNode(Node node, SimpleWriter simpleWriter) throws DOMException, IOException {
        this.rootNode = node;
        CSSStyleSheet<?> cSSStyleSheet = this.uaSheet;
        if (cSSStyleSheet == null) {
            DOMDocument dOMDocument = (DOMDocument)this.getOwnerDocument();
            this.uaSheet = dOMDocument.getImplementation().getUserAgentStyleSheet(dOMDocument.getComplianceMode());
        }
        this.writeNode(node, simpleWriter, true);
        this.uaSheet = cSSStyleSheet;
        this.rootNode = null;
    }

    protected void writeNode(Node node, SimpleWriter simpleWriter, boolean bl) throws DOMException, IOException {
        switch (node.getNodeType()) {
            case 1: {
                this.writeElement((DOMElement)node, simpleWriter, bl);
                break;
            }
            case 3: {
                Text text = (Text)node;
                if (!text.isElementContentWhitespace() || this.isParentWhitespacePreserving(text)) {
                    this.writeText(text, simpleWriter, bl);
                    break;
                }
                if (bl) break;
                this.writeElementContentWhitespace(text, simpleWriter);
                break;
            }
            case 4: {
                this.writeCDataSection((CDATASection)node, simpleWriter);
                break;
            }
            case 8: {
                this.writeComment((Comment)node, simpleWriter, bl);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node, simpleWriter);
                break;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node, simpleWriter);
                break;
            }
            case 9: 
            case 11: {
                if (!node.hasChildNodes()) break;
                this.writeChildNodes(node, simpleWriter, bl);
                break;
            }
            case 5: {
                this.writeEntityReference(node, simpleWriter);
                break;
            }
            default: {
                simpleWriter.write((CharSequence)node.toString());
            }
        }
    }

    protected void writeElement(DOMElement dOMElement, SimpleWriter simpleWriter, boolean bl) throws DOMException, IOException {
        if (bl) {
            this.startIndentedNode(dOMElement, simpleWriter);
        }
        String string = dOMElement.getTagName();
        simpleWriter.write('<');
        simpleWriter.write((CharSequence)string);
        String string2 = dOMElement.getNamespaceURI();
        DOMNode dOMNode = dOMElement.getParentNode();
        if (dOMNode != null) {
            String string3 = dOMElement.getPrefix();
            if (string2 != null && string3 != null && !string3.equals(dOMNode.lookupPrefix(string2)) && !this.hasXmlnsAttr(dOMElement.getAttributes(), string3, string2)) {
                Attr attr = this.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3);
                attr.setValue(string2);
                simpleWriter.write(' ');
                this.writeAttribute(attr, simpleWriter);
            }
        }
        this.writeAttributes(dOMElement.getAttributes(), simpleWriter);
        if (dOMElement.hasChildNodes() || !dOMElement.isNonHTMLOrVoid()) {
            simpleWriter.write('>');
            boolean bl2 = this.afterStartTag(dOMElement, simpleWriter);
            if (dOMElement.hasChildNodes()) {
                if (bl2) {
                    this.startIndentedNodeList(dOMElement, simpleWriter);
                }
                this.writeChildNodes(dOMElement, simpleWriter, bl2);
                if (bl2) {
                    this.endIndentedNodeList(dOMElement, simpleWriter);
                }
            }
            if (bl2) {
                this.writeFullIndent(simpleWriter);
            }
            simpleWriter.write((CharSequence)"</");
            simpleWriter.write((CharSequence)string);
            simpleWriter.write((CharSequence)">");
        } else {
            if (string2 == "http://www.w3.org/1999/xhtml") {
                simpleWriter.write(' ');
            }
            simpleWriter.write((CharSequence)"/>");
        }
        if (bl) {
            this.endIndentedNode(dOMElement, simpleWriter);
        }
    }

    private boolean hasXmlnsAttr(AttributeNamedNodeMap attributeNamedNodeMap, String string, String string2) throws DOMException {
        if (!attributeNamedNodeMap.isEmpty()) {
            for (Attr attr : attributeNamedNodeMap) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !string2.equals(attr.getValue())) continue;
                String string3 = attr.getLocalName();
                String string4 = attr.getPrefix();
                if (!"xmlns".equals(string4)) continue;
                if (string.equals(string3)) {
                    return true;
                }
                throw new DOMException(14, "Two prefixes for same namespace (" + string2 + "): '" + string + "' and '" + string4 + "'.");
            }
        }
        return false;
    }

    protected void writeAttributes(AttributeNamedNodeMap attributeNamedNodeMap, SimpleWriter simpleWriter) throws IOException {
        for (Attr attr : attributeNamedNodeMap) {
            if (!attr.getSpecified()) continue;
            simpleWriter.write(' ');
            this.writeAttribute(attr, simpleWriter);
        }
    }

    protected void writeAttribute(Attr attr, SimpleWriter simpleWriter) throws IOException {
        ((DOMAttr)attr).write(simpleWriter);
    }

    protected void writeChildNodes(Node node, SimpleWriter simpleWriter, boolean bl) throws DOMException, IOException {
        DOMNodeList dOMNodeList = ((DOMNode)node).getChildNodes();
        for (DOMNode dOMNode : dOMNodeList) {
            this.writeNode(dOMNode, simpleWriter, bl);
        }
    }

    private boolean isParentWhitespacePreserving(Text text) {
        Node node = text.getParentNode();
        if (node.getNodeType() == 1) {
            String string = ((DOMElement)node).getComputedStyle(null).getPropertyValue("white-space");
            return "pre".equalsIgnoreCase(string) || "pre-wrap".equalsIgnoreCase(string) || "break-spaces".equalsIgnoreCase(string);
        }
        return false;
    }

    protected void writeText(Text text, SimpleWriter simpleWriter, boolean bl) throws IOException {
        boolean bl2 = bl && !this.previousSiblingWasTextOrERef(text);
        Node node = text.getParentNode();
        if (node != null && node.getNodeType() == 1 && this.isRawTextElement((DOMElement)node)) {
            String string = node.getLocalName();
            this.writeRawText(text, string, simpleWriter);
        } else {
            this.writeNonRawText(text, simpleWriter, bl2);
        }
    }

    private boolean previousSiblingWasTextOrERef(Text text) {
        short s;
        Node node = text.getPreviousSibling();
        return node != null && ((s = node.getNodeType()) == 3 || s == 5);
    }

    protected boolean isRawTextElement(DOMElement dOMElement) {
        return dOMElement.isRawText();
    }

    protected void writeRawText(Text text, String string, SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)DOMDocument.escapeCloseTag(string, text.getData()));
    }

    protected void writeNonRawText(Text text, SimpleWriter simpleWriter, boolean bl) throws IOException {
        String string = text.getData();
        if (bl) {
            String string2 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.writeFullIndent(simpleWriter);
                string2 = stringTokenizer.nextToken();
                this.writeTextLine(string2, simpleWriter);
            }
            if (!string2.endsWith("\n")) {
                this.endIndentedNode(text, simpleWriter);
            }
        } else {
            this.writeTextLine(string, simpleWriter);
        }
    }

    protected void writeTextLine(String string, SimpleWriter simpleWriter) throws IOException {
        if (string.length() != 0) {
            if (this.entityMap != null) {
                try {
                    string = this.replaceByEntities(string);
                }
                catch (SAXException sAXException) {}
            } else {
                string = DOMDocument.escapeLtGtEntities(string);
            }
            simpleWriter.write((CharSequence)string);
        }
    }

    protected String replaceByEntities(String string) throws SAXException, IOException {
        StringBuilder stringBuilder = null;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            if (this.entityMap.containsKey(n3)) {
                String string2 = this.entityMap.get(n3);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n + 64);
                    stringBuilder.append(string.subSequence(0, n2));
                }
                stringBuilder.append('&');
                if (string2 != null) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append('#').append(n3);
                }
                stringBuilder.append(';');
            } else if (stringBuilder != null) {
                stringBuilder.appendCodePoint(n3);
            }
            n2 = string.offsetByCodePoints(n2, 1);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private Document getOwnerDocument() {
        Document document = this.rootNode.getNodeType() == 9 ? (Document)this.rootNode : this.rootNode.getOwnerDocument();
        return document;
    }

    protected void writeElementContentWhitespace(Text text, SimpleWriter simpleWriter) throws IOException {
        Node node;
        Node node2 = text.getPreviousSibling();
        String string = text.getData();
        if (string.length() == 0 || node2 == null || (node = text.getNextSibling()) == null || this.isBlockElementNode(node2) || this.isBlockElementNode(node)) {
            return;
        }
        if (string.indexOf(10) != -1) {
            simpleWriter.newLine();
            this.writeFullIndent(simpleWriter);
        } else {
            simpleWriter.write(' ');
        }
    }

    private boolean isBlockElementNode(Node node) {
        if (node.getNodeType() == 1) {
            DOMElement dOMElement = (DOMElement)node;
            ComputedCSSStyle computedCSSStyle = dOMElement.getComputedStyle(null);
            String string = computedCSSStyle.getPropertyValue("display");
            if (string.length() == 0) {
                string = this.getDisplayProperty(dOMElement);
            }
            if ("block".equalsIgnoreCase(string) || "table".equalsIgnoreCase(string) || "table-row".equalsIgnoreCase(string) || "inline-block".equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    protected void writeCDataSection(CDATASection cDATASection, SimpleWriter simpleWriter) throws IOException {
        boolean bl;
        AbstractDOMNode abstractDOMNode = ((AbstractDOMNode)((Object)cDATASection)).parentNode();
        boolean bl2 = bl = abstractDOMNode == null || abstractDOMNode.getNodeType() != 1 || !((DOMElement)abstractDOMNode).isRawText();
        if (bl) {
            this.startIndentedNode(cDATASection, simpleWriter);
        }
        simpleWriter.write((CharSequence)"<![CDATA[");
        simpleWriter.write((CharSequence)cDATASection.getData());
        simpleWriter.write((CharSequence)"]]>");
        if (bl) {
            this.endIndentedNode(cDATASection, simpleWriter);
        }
    }

    protected void writeComment(Comment comment, SimpleWriter simpleWriter, boolean bl) throws IOException {
        if (bl) {
            this.startIndentedNode(comment, simpleWriter);
        }
        simpleWriter.write((CharSequence)"<!--");
        simpleWriter.write((CharSequence)comment.getData());
        simpleWriter.write((CharSequence)"-->");
        if (bl) {
            this.endIndentedNode(comment, simpleWriter);
        }
    }

    protected void writeDocumentType(DocumentType documentType, SimpleWriter simpleWriter) throws IOException {
        this.startIndentedNode(documentType, simpleWriter);
        String string = documentType.getSystemId();
        boolean bl = string != null && string.length() != 0;
        simpleWriter.write((CharSequence)"<!DOCTYPE ");
        String string2 = documentType.getName();
        string2 = DOMAttr.escapeAttributeEntities(string2);
        simpleWriter.write((CharSequence)string2);
        String string3 = documentType.getPublicId();
        if (string3 != null && string3.length() != 0) {
            simpleWriter.write((CharSequence)" PUBLIC \"");
            simpleWriter.write((CharSequence)DOMAttr.escapeAttributeEntities(string3));
            simpleWriter.write('\"');
        } else if (bl) {
            simpleWriter.write((CharSequence)" SYSTEM");
        }
        if (bl) {
            simpleWriter.write((CharSequence)" \"");
            simpleWriter.write((CharSequence)DOMAttr.escapeAttributeEntities(string));
            simpleWriter.write('\"');
        }
        simpleWriter.write('>');
        this.endIndentedNode(documentType, simpleWriter);
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction, SimpleWriter simpleWriter) throws IOException {
        this.startIndentedNode(processingInstruction, simpleWriter);
        simpleWriter.write((CharSequence)"<?");
        simpleWriter.write((CharSequence)processingInstruction.getTarget());
        simpleWriter.write(' ');
        simpleWriter.write((CharSequence)processingInstruction.getData());
        simpleWriter.write((CharSequence)"?>");
        this.endIndentedNode(processingInstruction, simpleWriter);
    }

    protected void writeEntityReference(Node node, SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write('&');
        simpleWriter.write((CharSequence)node.getNodeName());
        simpleWriter.write(';');
    }

    protected void startIndentedNodeList(Node node, SimpleWriter simpleWriter) throws IOException {
        this.deepenIndent();
    }

    protected void startIndentedNode(Node node, SimpleWriter simpleWriter) throws IOException {
        this.writeFullIndent(simpleWriter);
    }

    protected void endIndentedNode(Node node, SimpleWriter simpleWriter) throws IOException {
        simpleWriter.newLine();
    }

    protected void endIndentedNodeList(Node node, SimpleWriter simpleWriter) throws IOException {
        this.updateIndent(node);
    }

    protected boolean afterStartTag(DOMElement dOMElement, SimpleWriter simpleWriter) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        ElementList elementList = dOMElement.getChildren();
        if (!elementList.isEmpty()) {
            for (DOMElement dOMElement2 : elementList) {
                String string = this.getDisplayProperty(dOMElement2);
                if (!"block".equalsIgnoreCase(string) && !"table".equalsIgnoreCase(string) && !"table-row".equalsIgnoreCase(string) && !"inline-block".equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            this.effectiveTextContent(dOMElement, stringBuilder);
            int n = stringBuilder.length();
            if (n != 0) {
                boolean bl3 = bl2 = stringBuilder.charAt(0) == '\n';
                if (!bl) {
                    boolean bl4 = bl = n > 64;
                    if (!bl) {
                        boolean bl5 = bl = stringBuilder.charAt(n - 1) == '\n';
                    }
                }
            }
            if (!(!bl || this.isRawTextElement(dOMElement) && bl2)) {
                simpleWriter.newLine();
            }
        }
        return bl;
    }

    private void effectiveTextContent(DOMElement dOMElement, StringBuilder stringBuilder) {
        boolean bl = false;
        Iterator<DOMNode> iterator = dOMElement.iterator();
        while (iterator.hasNext()) {
            DOMNode dOMNode = iterator.next();
            short s = dOMNode.getNodeType();
            if (s == 1) {
                if (dOMNode.hasChildNodes()) {
                    this.effectiveTextContent((DOMElement)dOMNode, stringBuilder);
                }
                bl = true;
                continue;
            }
            if (s == 3) {
                if (!((Text)((Object)dOMNode)).isElementContentWhitespace()) {
                    stringBuilder.append(dOMNode.getNodeValue());
                    continue;
                }
                if (!bl) continue;
                stringBuilder.append(' ');
                continue;
            }
            if (s != 4) continue;
            stringBuilder.append(dOMNode.getNodeValue());
        }
    }

    protected String getDisplayProperty(Element element) {
        CSSRuleList<CSSRule> cSSRuleList;
        String string;
        String string2 = element.getLocalName();
        if (this.displayMap == null) {
            this.displayMap = new HashMap();
        }
        if ((string = this.displayMap.get(string2)) == null && this.uaSheet != null && (cSSRuleList = this.uaSheet.getRulesForProperty("display")) != null) {
            for (CSSRule cSSRule : cSSRuleList) {
                if (cSSRule.getType() != 1) continue;
                CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSRule;
                SelectorList selectorList = cSSStyleRule.getSelectorList();
                for (int i = 0; i < selectorList.getLength(); ++i) {
                    Selector selector = selectorList.item(i);
                    if (selector.getSelectorType() != Selector.SelectorType.ELEMENT || !string2.equals(((ElementSelector)selector).getLocalName()) || (string = cSSStyleRule.getStyle().getPropertyValue("display")) == null) continue;
                    this.displayMap.put(string2, string);
                    return string;
                }
            }
        }
        return string;
    }

    protected void deepenIndent() {
        this.indentString.append(this.indentingUnit);
    }

    protected void updateIndent(Node node) {
        Node node2;
        this.indentString.setLength(0);
        if (node2 != null) {
            for (node2 = node.getParentNode(); node2 != this.rootNode; node2 = node2.getParentNode()) {
                this.deepenIndent();
            }
        }
    }

    protected void writeFullIndent(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.indentString);
    }
}

