############################################################################
##
#W lpres.gd 			The LPRES-package		René Hartung
##

############################################################################
##
#C  IsElementOfLpGroup
##
DeclareCategory( "IsElementOfLpGroup", 
   IsMultiplicativeElementWithInverse and IsAssociativeElement );

############################################################################
##
#C  IsElementOfLpGroupCollection
##
DeclareCategoryCollections( "IsElementOfLpGroup" );

############################################################################
##
#C  IsElementOfLpGroupFamily
##
DeclareCategoryFamily( "IsElementOfLpGroup" );


############################################################################
##
#C IsSubgroupLpGroup
##
DeclareCategory( "IsSubgroupLpGroup", IsSubgroupFgGroup );

InstallTrueMethod( IsSubgroupLpGroup, IsGroup and IsElementOfLpGroupCollection);
#InstallTrueMethod( IsSubgroupLpGroup, IsGroup and IsAssocWordCollection );

############################################################################
##
#C  IsLpGroup
##
#DeclareSynonym( "IsLpGroup", IsSubgroupLpGroup and IsWholeFamily );
DeclareSynonym( "IsLpGroup", IsSubgroupLpGroup and IsGroupOfFamily );

#InstallTrueMethod( IsLpGroup, IsGroup and IsElementOfLpGroupCollection );
#InstallTrueMethod( IsLpGroup, IsGroup and IsGroupOfFamily );

############################################################################
##
#O  ElementOfLpGroup( <fam>, <word> )
##
## If <fam> is the elements-family of an L-presented group and <word> is a 
## word in the free generators underlying this L-presented group, this 
## operation creates the element with the representative <word> in the 
## LpGroup with elements-family <fam>.
## 
DeclareOperation( "ElementOfLpGroup",
                [ IsElementOfLpGroupFamily, IsAssocWordWithInverse ]);

InstallTrueMethod( IsGeneratorsOfMagmaWithInverses,
   IsElementOfLpGroupCollection );

############################################################################
##
#P  IsInvariantLPresentation ( <G> )
##
DeclareProperty( "IsInvariantLPresentation", IsLpGroup );

############################################################################
##
#P  IsAscendingLPresentation ( <G> )
##
DeclareProperty( "IsAscendingLPresentation", IsLpGroup );

#############################################################################
##
#A  FreeGeneratorsOfLpGroup( <G> )
##
## `FreeGeneratorsOfLpGroup' returns the underlying free generators
## corresponding to the generators of the L-presented group <G>.
##
DeclareAttribute( "FreeGeneratorsOfLpGroup", IsLpGroup and IsGroupOfFamily  );
DeclareOperation( "FreeGeneratorsOfWholeGroup", [ IsSubgroupLpGroup ] );
DeclareOperation( "FreeGroupOfWholeGroup", [ IsSubgroupLpGroup ] );

############################################################################
##
#A  FixedRelatorsOfLpGroup( <G> )
##
## returns the fixed relators of the L-presented group <G> as words
## in the free generators obtained from `FreeGeneratorsOfFpGroup'.
##
DeclareAttribute("FixedRelatorsOfLpGroup",IsLpGroup and IsGroupOfFamily);

############################################################################
##
#A  EndomorphismsOfLpGroup( <G> )
##
## returns the endomorphisms of the L-presented group <G> as group 
## homomorphisms of the underlying free group.
##
DeclareAttribute( "EndomorphismsOfLpGroup", IsLpGroup and IsGroupOfFamily );

############################################################################
##
#A  IteratedRelatorsOfLpGroup( <G> )
##
## returns the iterated relators of the L-presented group <G> as words
## in the free generators obtained from `FreeGeneratorsOfFpGroup'.
##
DeclareAttribute( "IteratedRelatorsOfLpGroup", IsLpGroup and IsGroupOfFamily );

############################################################################
##
#A  FreeGroupOfLpGroup(<G>)
##
## returns the underlying free group of the L-presented group <G>; i.e.
## the group generated by the free generators obtained from
## `FreeGeneratorsOfFpGroup'.
##
DeclareAttribute( "FreeGroupOfLpGroup", IsLpGroup and IsGroupOfFamily );

############################################################################
##
#F  LPresentedGroup ( <FreeGroup>, <rels>, <endos>, <itrels> )
##
## constructs the L-presented group on the generators of <FreeGroup> with 
## the fixed relators <rels>, the free group endomorphisms <endos>, 
## and the iterated relators <itrels>.
##
DeclareGlobalFunction( "LPresentedGroup" );

############################################################################
##
#A  UnderlyingAscendingLPresentation( <LpGroup> )
##
## returns the underlying ascending L-presentation. 
##
DeclareAttribute( "UnderlyingAscendingLPresentation", IsLpGroup );

############################################################################
##
#A  UnderlyingInvariantLPresentation( <LpGroup> )
##
## attempts to compute an underlying invariant L-presentation for the
## group <LpGroup>. In the worst case, this routine returns the underlying
## ascending L-presentation. This attribute can be set manually by the user
## using `SetUnderlyingInvariantLPresentation'.
##
DeclareAttribute( "UnderlyingInvariantLPresentation", IsLpGroup );

############################################################################
##
#A  EmbeddingOfAscendingSubgroup ( <LpGroup> )
##
## an attribute which stores an embedding of an ascending L-presented 
## subgroup of the L-presented group <LpGroup>. This is useful for the 
## construction in FR of the Gupta-Sidki-Groups with its invariantly 
## L-presented index-3 subgroup.
##
DeclareAttribute( "EmbeddingOfAscendingSubgroup", IsLpGroup );

############################################################################
##
#O  EpimorphismFromFpGroup ( <LpGroup>, <n> )
##
## returns an epimorphism from a finitely presented group G which is obtained
## from <LpGroup> by applying word of length at most <n> in the endomorphisms 
## of the L-presented group <LpGroup>
##
DeclareOperation( "EpimorphismFromFpGroup", [ IsLpGroup, IsPosInt ] );

############################################################################
##
#O  SplitExtensionByAutomorphismsLpGroup ( <G>, <H>, <auts> )
##
## returns the split extension of <G> by <H> where the action of each 
## generator of <H> on <G> is given by the automorphisms <aut>: <H> -> <G>
## in the list <auts>.
##
DeclareOperation( "SplitExtensionByAutomorphismsLpGroup",
                 [ IsLpGroup, IsGroup, IsList ]);

############################################################################
##
#O  AsLpGroup ( <G> )
##
## returns an L-presented group which is isomorphic to <G>
##
DeclareOperation( "AsLpGroup", [ IsGroup ]);
#DeclareOperation( "AsLpGroup", [ IsFreeGroup ]);

############################################################################
##
#O  IsomorphismLpGroup ( <G> )
##
## returns an isomorphism from an FpGroup (or from a FreeGroup) to the LpGroup
## obtained from `AsLpGroup'.
##
DeclareAttribute( "IsomorphismLpGroup", IsGroup );

############################################################################
##
#P  IsFinitelyPresentable( <LpGroup> )
##
## stores if <LpGroup> is finitely presentable; e.g. if <LpGroup> is returned
## by IsomorphismLpGroup applied to an FpGroup.
##
DeclareProperty( "IsFinitelyPresentable", IsGroup );

############################################################################
##
#A  CoveringGroups( <LpGroup> ) . . . . . stores the (nilp.) covering groups
##
DeclareAttribute( "CoveringGroups", IsLpGroup and 
                   HasIsInvariantLPresentation and IsInvariantLPresentation );

############################################################################
##
#O  EpimorphismCoveringGroups( <LpGroup>, <int>, <int> ) 
##
DeclareOperation( "EpimorphismCoveringGroups", [ IsLpGroup and 
                   HasIsInvariantLPresentation and IsInvariantLPresentation, 
                   IsPosInt, IsPosInt ] );
