# R<X>:=PolynomialRing(Rationals());F<b5>:=NumberField(X^2+X-1);r5:=2*b5+1;
local result, l, r5, b5;
r5:= Sqrt(5);
b5:=(-1+r5)/2;
result:= rec();
result.comment:=
"A6 as 8 x 8 matrices over Z[b5].\n\
Representation 8b.\n\
Absolutely irreducible representation.\n\
Schur Index 1.\n\
\n\
SEED:\n\
Nonzero v fixed by <x,y*x*y^-1> = D8.\n\
v has 1 x 45 = 45 images under G; <v> has 45 images under G.\n\
BASIS:\n\
All in v^G.\n\
\n\
Possible matrix entries are in {-1,0,1,b5,b5+1,-b5,-b5-1} (norms 0, 1 only).\n\
\n\
Average number of nonzero entries for any element of the group:\n\
31 + 13/45  (about 31.289; 48.889%).\n\
\n\
  Entry  Av/Mat             %Av/Mat\n\
      0  32.711 [32+32/45]   51.111 [51+1/9]\n\
nonzero  31.289 [31+13/45]   48.889 [48+8/9]\n\
     1  15.644 [15+29/45]   24.444 [24+4/9]\n\
      1   7.822  [7+37/45]   12.222 [12+2/9]\n\
     -1   7.822  [7+37/45]   12.222 [12+2/9]\n\
  1b5  12.644 [15+29/45]   24.444 [24+4/9]\n\
     b5   3.911  [3+41/45]    6.111  [6+1/9]\n\
    -b5   3.911  [3+41/45]    6.111  [6+1/9]\n\
   1+b5   3.911  [3+41/45]    6.111  [6+1/9]\n\
  -1-b5   3.911  [3+41/45]    6.111  [6+1/9]\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
1,0,0,0,0,0,0,0,
1,-1,1,1,1,1,-1,1,
0,0,0,0,0,0,0,1,
b5+1,0,0,b5,b5+1,b5,-b5-1,0,
-b5-1,0,0,-b5,-b5-1,-b5,b5,0,
0,0,0,0,0,1,0,0,
0,0,0,-1,-1,0,0,0,
0,0,1,0,0,0,0,0]
,[
1,0,1,0,0,1,0,1,
1,0,0,0,b5+1,0,-b5-1,0,
0,0,0,0,1,0,0,0,
b5+1,0,0,0,1,0,-b5-1,0,
-b5-1,0,0,b5,-1,-1,1,0,
0,-1,0,0,0,0,-1,0,
0,b5,0,0,-b5,0,0,1,
0,0,0,1,0,0,0,0]
], l -> List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );


l:= [
8,-3*b5-1,-1,-1,-3*b5-1,-4,3*b5+2,-1,
-3*b5-1,8,3*b5+2,3*b5+2,-3*b5-1,3*b5+2,-4,-3*b5-1,
-1,3*b5+2,8,-3*b5-1,-1,-1,-3*b5-1,-4,
-1,3*b5+2,-3*b5-1,8,-4,3*b5+2,-3*b5-1,-1,
-3*b5-1,-3*b5-1,-1,-4,8,-1,3*b5+2,3*b5+2,
-4,3*b5+2,-1,3*b5+2,-1,8,-3*b5-1,-1,
3*b5+2,-4,-3*b5-1,-3*b5-1,3*b5+2,-3*b5-1,8,3*b5+2,
-1,-3*b5-1,-4,-1,3*b5+2,-1,3*b5+2,8];
Add( result.symmetricforms, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );


Add( result.centralizeralgebra, IdentityMat(8) );
return result;
