/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListener;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;

class PopupMenuListenerForEntry
implements PopupMenuListener {
    private final Entry entry;
    private final EntryPopupListener popupListener;
    final EntryAccessor entryAccessor;

    PopupMenuListenerForEntry(Entry entry, EntryPopupListener popupListener, ResourceAccessor resourceAccessor) {
        this.entry = entry;
        this.popupListener = popupListener;
        this.entryAccessor = new EntryAccessor(resourceAccessor);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        PopupTimer popupTimer = this.entry.getAttribute(PopupTimer.class);
        if (popupTimer != null) {
            popupTimer.stop();
            this.entry.removeAttribute(PopupTimer.class);
            this.fireChildEntriesHidden(this.entry);
        }
        this.fireChildEntriesWillBecomeVisible(this.entry);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        PopupTimer popupTimer = new PopupTimer(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuListenerForEntry.this.entry.removeAttribute(PopupTimer.class);
                PopupMenuListenerForEntry.this.fireChildEntriesHidden(PopupMenuListenerForEntry.this.entry);
            }
        });
        this.entry.setAttribute(PopupTimer.class, (Object)popupTimer);
        popupTimer.setRepeats(false);
        popupTimer.start();
    }

    private void fireChildEntriesWillBecomeVisible(Entry entry) {
        this.popupListener.childEntriesWillBecomeVisible(entry);
        for (Entry child : entry.children()) {
            if (RecursiveMenuStructureProcessor.shouldProcessUiOnEvent(child)) continue;
            this.fireChildEntriesWillBecomeVisible(child);
        }
    }

    private void fireChildEntriesHidden(Entry entry) {
        this.popupListener.childEntriesHidden(entry);
        for (Entry child : entry.children()) {
            if (RecursiveMenuStructureProcessor.shouldProcessUiOnEvent(child)) continue;
            this.fireChildEntriesHidden(child);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private static class PopupTimer
    extends Timer {
        private static final int DELAY = 20;

        public PopupTimer(ActionListener listener) {
            super(20, listener);
        }
    }
}

