/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.render.pdf.extensions.PDFDictionaryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;

public class PDFPageExtension
extends PDFDictionaryExtension {
    public static final String PROPERTY_PAGE_NUMBERS = "page-numbers";

    PDFPageExtension() {
        super(PDFDictionaryType.Page);
    }

    public boolean matchesPageNumber(int pageNumber) {
        String pageNumbers = this.getProperty(PROPERTY_PAGE_NUMBERS);
        if (pageNumbers == null || pageNumbers.length() == 0) {
            return false;
        }
        if (pageNumbers.equals("*")) {
            return true;
        }
        for (String interval : pageNumbers.split("\\s*,\\s*")) {
            String[] components = interval.split("\\s*-\\s*");
            if (components.length < 1) continue;
            try {
                int start = Integer.parseInt(components[0]);
                int end = 0;
                if (components.length > 1 && !components[1].equals("LAST")) {
                    end = Integer.parseInt(components[1]);
                }
                if (end == 0 && pageNumber == start) {
                    return true;
                }
                if (end <= start || pageNumber < start || pageNumber >= end) continue;
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }
}

