/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.Value;

public class MethodOptimizationInfo {
    protected boolean hasNoSideEffects = false;
    protected boolean hasNoExternalSideEffects = false;
    protected boolean hasNoEscapingParameters = false;
    protected boolean hasNoExternalReturnValues = false;
    protected Value returnValue = null;

    public boolean isKept() {
        return true;
    }

    public void setNoSideEffects() {
        this.hasNoSideEffects = true;
        this.hasNoExternalSideEffects = true;
        this.hasNoEscapingParameters = true;
    }

    public boolean hasNoSideEffects() {
        return this.hasNoSideEffects;
    }

    public void setNoExternalSideEffects() {
        this.hasNoExternalSideEffects = true;
        this.hasNoEscapingParameters = true;
    }

    public boolean hasNoExternalSideEffects() {
        return this.hasNoExternalSideEffects;
    }

    public void setNoEscapingParameters() {
        this.hasNoEscapingParameters = true;
    }

    public boolean hasNoEscapingParameters() {
        return this.hasNoEscapingParameters;
    }

    public void setNoExternalReturnValues() {
        this.hasNoExternalReturnValues = true;
    }

    public boolean hasNoExternalReturnValues() {
        return this.hasNoExternalReturnValues;
    }

    public void setReturnValue(Value returnValue) {
        this.returnValue = returnValue;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }

    public boolean hasSideEffects() {
        return !this.hasNoSideEffects;
    }

    public boolean canBeMadePrivate() {
        return false;
    }

    public boolean catchesExceptions() {
        return true;
    }

    public boolean branchesBackward() {
        return true;
    }

    public boolean invokesSuperMethods() {
        return true;
    }

    public boolean invokesDynamically() {
        return true;
    }

    public boolean accessesPrivateCode() {
        return true;
    }

    public boolean accessesPackageCode() {
        return true;
    }

    public boolean accessesProtectedCode() {
        return true;
    }

    public boolean hasSynchronizedBlock() {
        return true;
    }

    public boolean assignsFinalField() {
        return true;
    }

    public boolean returnsWithNonEmptyStack() {
        return false;
    }

    public int getInvocationCount() {
        return Integer.MAX_VALUE;
    }

    public int getParameterSize() {
        return 0;
    }

    public boolean hasUnusedParameters() {
        return false;
    }

    public boolean isParameterUsed(int variableIndex) {
        return true;
    }

    public long getUsedParameters() {
        return -1L;
    }

    public boolean hasParameterEscaped(int parameterIndex) {
        return true;
    }

    public long getEscapedParameters() {
        return -1L;
    }

    public boolean isParameterEscaping(int parameterIndex) {
        return !this.hasNoEscapingParameters;
    }

    public long getEscapingParameters() {
        return this.hasNoEscapingParameters ? 0L : -1L;
    }

    public boolean isParameterModified(int parameterIndex) {
        return !this.hasNoSideEffects && (!this.hasNoExternalSideEffects || parameterIndex == 0);
    }

    public long getModifiedParameters() {
        return this.hasNoSideEffects ? 0L : (this.hasNoExternalSideEffects ? 1L : -1L);
    }

    public boolean modifiesAnything() {
        return !this.hasNoExternalSideEffects;
    }

    public Value getParameterValue(int parameterIndex) {
        return null;
    }

    public boolean returnsParameter(int parameterIndex) {
        return true;
    }

    public long getReturnedParameters() {
        return -1L;
    }

    public boolean returnsNewInstances() {
        return true;
    }

    public boolean returnsExternalValues() {
        return !this.hasNoExternalReturnValues;
    }

    public static void setMethodOptimizationInfo(Clazz clazz, Method method) {
        MethodLinker.lastMember(method).setVisitorInfo(new MethodOptimizationInfo());
    }

    public static MethodOptimizationInfo getMethodOptimizationInfo(Method method) {
        return (MethodOptimizationInfo)MethodLinker.lastMember(method).getVisitorInfo();
    }
}

