/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.io.ProgramClassWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class ClassDataEntryWriter
implements DataEntryWriter {
    private final ClassPool classPool;
    private final DataEntryWriter dataEntryWriter;

    public ClassDataEntryWriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        String inputName = dataEntry.getName();
        String name = dataEntry.getName();
        if (name.endsWith(".class")) {
            String className = inputName.substring(0, inputName.length() - ".class".length());
            Clazz clazz = this.classPool.getClass(className);
            if (clazz != null) {
                OutputStream outputStream;
                String newClassName = clazz.getName();
                if (!className.equals(newClassName)) {
                    dataEntry = new RenamedDataEntry(dataEntry, newClassName + ".class");
                }
                if ((outputStream = this.dataEntryWriter.createOutputStream(dataEntry)) != null) {
                    try (DataOutputStream classOutputStream = new DataOutputStream(outputStream);){
                        clazz.accept(new ProgramClassWriter(classOutputStream));
                    }
                }
            }
            return new FilterOutputStream(null);
        }
        return this.dataEntryWriter.createOutputStream(dataEntry);
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "ClassDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }
}

