/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAccessFilter
implements MemberVisitor {
    private static final int ACCESS_MASK = 7;
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final int requiredOneSetAccessFlags;
    private final MemberVisitor memberVisitor;

    public MemberAccessFilter(int requiredSetAccessFlags, int requiredUnsetAccessFlags, MemberVisitor memberVisitor) {
        this.requiredSetAccessFlags = requiredSetAccessFlags & 0xFFFFFFF8;
        this.requiredUnsetAccessFlags = requiredUnsetAccessFlags;
        this.requiredOneSetAccessFlags = requiredSetAccessFlags & 7;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.accepted(programField.getAccessFlags())) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.accepted(programMethod.getAccessFlags())) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.accepted(libraryField.getAccessFlags())) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.accepted(libraryMethod.getAccessFlags())) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean accepted(int accessFlags) {
        return (this.requiredSetAccessFlags & ~accessFlags) == 0 && (this.requiredUnsetAccessFlags & accessFlags) == 0 && (this.requiredOneSetAccessFlags == 0 || (this.requiredOneSetAccessFlags & accessFlags) != 0);
    }
}

