﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/RegistrationInformation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class DescribeRegistrationsResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationsResult() = default;
  AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API DescribeRegistrationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of RegistrationInformation objects.</p>
   */
  inline const Aws::Vector<RegistrationInformation>& GetRegistrations() const { return m_registrations; }
  template <typename RegistrationsT = Aws::Vector<RegistrationInformation>>
  void SetRegistrations(RegistrationsT&& value) {
    m_registrationsHasBeenSet = true;
    m_registrations = std::forward<RegistrationsT>(value);
  }
  template <typename RegistrationsT = Aws::Vector<RegistrationInformation>>
  DescribeRegistrationsResult& WithRegistrations(RegistrationsT&& value) {
    SetRegistrations(std::forward<RegistrationsT>(value));
    return *this;
  }
  template <typename RegistrationsT = RegistrationInformation>
  DescribeRegistrationsResult& AddRegistrations(RegistrationsT&& value) {
    m_registrationsHasBeenSet = true;
    m_registrations.emplace_back(std::forward<RegistrationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to be used for the next set of paginated results. You don't need to
   * supply a value for this field in the initial request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeRegistrationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeRegistrationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<RegistrationInformation> m_registrations;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_registrationsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
