/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.project.ngm.math.AbstractPiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public class Combiner {
    public static PiecewiseConstant sum(PiecewiseConstant ... functions) {
        throw new UnsupportedOperationException("Work in progress");
    }

    public static PiecewiseConstant product(PiecewiseConstant ... functions) {
        return CombinedPiecewiseConstant.of(Fraction.PRODUCT).with(functions);
    }

    public static class CombinedPiecewiseConstant
    extends AbstractPiecewiseConstant {
        private final List<PiecewiseConstant> functions;
        private final BiFunction<Fraction, Fraction, Fraction> valueCombiner;

        private CombinedPiecewiseConstant(List<PiecewiseConstant> functions, BiFunction<Fraction, Fraction, Fraction> valueCombiner) {
            Objects.requireNonNull(functions, "functions must not be null");
            Objects.requireNonNull(valueCombiner, "valueCombiner must not be null");
            this.functions = functions;
            this.valueCombiner = valueCombiner;
        }

        private CombinedPiecewiseConstant(BiFunction<Fraction, Fraction, Fraction> valueCombiner) {
            this.valueCombiner = valueCombiner;
            this.functions = Collections.emptyList();
        }

        @Override
        public Segment segmentAt(LocalDateTime instant, TimeDirection direction) {
            if (this.functions.size() < 2) {
                throw new IllegalStateException("At least two functions are required for combination");
            }
            List<Segment> segments = this.functions.stream().map(f -> f.segmentAt(instant, direction)).collect(Collectors.toList());
            return Segment.intersection(segments, this.valueCombiner);
        }

        public static CombinedPiecewiseConstant of(BiFunction<Fraction, Fraction, Fraction> valueCombiner) {
            return new CombinedPiecewiseConstant(valueCombiner);
        }

        public CombinedPiecewiseConstant with(List<PiecewiseConstant> functions) {
            ArrayList<PiecewiseConstant> newFunctions = new ArrayList<PiecewiseConstant>(this.functions);
            newFunctions.addAll(functions);
            return new CombinedPiecewiseConstant(newFunctions, this.valueCombiner);
        }

        public CombinedPiecewiseConstant with(PiecewiseConstant ... functions) {
            return this.with(Arrays.asList(functions));
        }
    }
}

