/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;

public class BrailleDrawer
implements UDrawable {
    private final BrailleGrid grid;
    private final double step = 9.0;
    private final double spotSize = 5.0;

    public BrailleDrawer(BrailleGrid grid) {
        this.grid = grid;
    }

    @Override
    public void drawU(UGraphic ug) {
        int x;
        ug = ug.apply(HColorSet.instance().getColorOrWhite("#F0F0F0"));
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            ug.apply(UTranslate.dx((double)x * 9.0 + 5.0 + 1.0)).draw(ULine.vline((double)(this.grid.getMaxY() - this.grid.getMinY()) * 9.0));
        }
        for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
            ug.apply(UTranslate.dy((double)y * 9.0 + 5.0 + 1.0)).draw(ULine.hline((double)(this.grid.getMaxX() - this.grid.getMinX()) * 9.0));
        }
        ug = ug.apply(HColors.BLACK).apply(HColors.BLACK.bg());
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
                if (!this.grid.getState(x, y)) continue;
                this.drawCircle(ug, x, y);
            }
        }
    }

    private void drawCircle(UGraphic ug, int x, int y) {
        double cx = (double)x * 9.0;
        double cy = (double)y * 9.0;
        ug.apply(new UTranslate(cx, cy)).draw(UEllipse.build(5.0, 5.0));
    }
}

