/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.resthandler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.action.BaseResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.notifications.metrics.Metrics;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/notifications/resthandler/RestResponseToXContentListener;", "Response", "Lorg/opensearch/commons/notifications/action/BaseResponse;", "Lorg/opensearch/rest/action/RestToXContentListener;", "channel", "Lorg/opensearch/rest/RestChannel;", "<init>", "(Lorg/opensearch/rest/RestChannel;)V", "buildResponse", "Lorg/opensearch/rest/RestResponse;", "response", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "(Lorg/opensearch/commons/notifications/action/BaseResponse;Lorg/opensearch/core/xcontent/XContentBuilder;)Lorg/opensearch/rest/RestResponse;", "getStatus", "Lorg/opensearch/core/rest/RestStatus;", "(Lorg/opensearch/commons/notifications/action/BaseResponse;)Lorg/opensearch/core/rest/RestStatus;", "opensearch-notifications"})
public final class RestResponseToXContentListener<Response extends BaseResponse>
extends RestToXContentListener<Response> {
    public RestResponseToXContentListener(@NotNull RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(channel);
    }

    @NotNull
    public RestResponse buildResponse(@NotNull Response response, @Nullable XContentBuilder builder) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        super.buildResponse((ToXContentObject)response, builder);
        Metrics.REQUEST_TOTAL.getCounter().increment();
        Metrics.REQUEST_INTERVAL_COUNT.getCounter().increment();
        RestStatus restStatus = response.getStatus();
        int n = WhenMappings.$EnumSwitchMapping$0[restStatus.ordinal()];
        RestStatus restStatus2 = RestStatus.OK;
        boolean bl = ((Comparable)restStatus).compareTo(RestStatus.MULTI_STATUS) <= 0 ? 0 <= ((Comparable)restStatus).compareTo(restStatus2) : false;
        if (bl) {
            Metrics.REQUEST_SUCCESS.getCounter().increment();
        } else if (n == 1) {
            Metrics.NOTIFICATIONS_SECURITY_USER_ERROR.getCounter().increment();
        } else {
            restStatus2 = RestStatus.UNAUTHORIZED;
            boolean bl2 = ((Comparable)restStatus).compareTo(RestStatus.TOO_MANY_REQUESTS) <= 0 ? 0 <= ((Comparable)restStatus).compareTo(restStatus2) : false;
            if (bl2) {
                Metrics.REQUEST_USER_ERROR.getCounter().increment();
            } else {
                Metrics.REQUEST_SYSTEM_ERROR.getCounter().increment();
            }
        }
        return (RestResponse)new BytesRestResponse(this.getStatus(response), builder);
    }

    @NotNull
    protected RestStatus getStatus(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        return response.getStatus();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestStatus.values().length];
            try {
                nArray[RestStatus.FORBIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

