/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;

public abstract class NumberPropertyBase
extends DocValuesPropertyBase {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;

    protected NumberPropertyBase(AbstractBuilder<?> builder) {
        super((DocValuesPropertyBase.AbstractBuilder<?>)builder);
        this.boost = ((AbstractBuilder)builder).boost;
        this.coerce = ((AbstractBuilder)builder).coerce;
        this.ignoreMalformed = ((AbstractBuilder)builder).ignoreMalformed;
        this.index = ((AbstractBuilder)builder).index;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupNumberPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        NumberPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(AbstractBuilder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(AbstractBuilder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(AbstractBuilder::index, JsonpDeserializer.booleanDeserializer(), "index");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + Objects.hashCode(this.coerce);
        result = 31 * result + Objects.hashCode(this.ignoreMalformed);
        result = 31 * result + Objects.hashCode(this.index);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberPropertyBase other = (NumberPropertyBase)o;
        return Objects.equals(this.boost, other.boost) && Objects.equals(this.coerce, other.coerce) && Objects.equals(this.ignoreMalformed, other.ignoreMalformed) && Objects.equals(this.index, other.index);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends DocValuesPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(NumberPropertyBase o) {
            super(o);
            this.boost = o.boost;
            this.coerce = o.coerce;
            this.ignoreMalformed = o.ignoreMalformed;
            this.index = o.index;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.boost = o.boost;
            this.coerce = o.coerce;
            this.ignoreMalformed = o.ignoreMalformed;
            this.index = o.index;
        }

        @Nonnull
        public final BuilderT boost(@Nullable Double value) {
            this.boost = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT coerce(@Nullable Boolean value) {
            this.coerce = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT index(@Nullable Boolean value) {
            this.index = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

