/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.model.DataByFeatureId;

public class ExpectedValueList
implements ToXContentObject,
Writeable {
    public static final String LIKELIHOOD_FIELD = "likelihood";
    private Double likelihood;
    private List<DataByFeatureId> valueList;

    public ExpectedValueList(Double likelihood, List<DataByFeatureId> valueList) {
        this.likelihood = likelihood;
        this.valueList = valueList;
    }

    public ExpectedValueList(StreamInput input) throws IOException {
        this.likelihood = input.readOptionalDouble();
        this.valueList = input.readList(DataByFeatureId::new);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.likelihood != null) {
            xContentBuilder.field(LIKELIHOOD_FIELD, this.likelihood);
        }
        if (this.valueList != null) {
            xContentBuilder.field("value_list", (Object)this.valueList.toArray());
        }
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.likelihood);
        out.writeList(this.valueList);
    }

    public static ExpectedValueList parse(XContentParser parser) throws IOException {
        Double likelihood = null;
        ArrayList<DataByFeatureId> valueList = new ArrayList<DataByFeatureId>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "likelihood": {
                    likelihood = parser.doubleValue();
                    continue block8;
                }
                case "value_list": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        valueList.add(DataByFeatureId.parse(parser));
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new ExpectedValueList(likelihood, valueList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpectedValueList that = (ExpectedValueList)o;
        return Double.compare(this.likelihood, that.likelihood) == 0 && Objects.equal(this.valueList, that.valueList);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.likelihood, this.valueList});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(LIKELIHOOD_FIELD, (Object)this.likelihood).append("valueList", (Object)StringUtils.join(this.valueList, (String)"|")).toString();
    }

    public Double getLikelihood() {
        return this.likelihood;
    }

    public List<DataByFeatureId> getValueList() {
        return this.valueList;
    }
}

