/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class DaySpanHandler {
    public RexNode createExpression(RexNode fieldExpr, int intervalDays, CalcitePlanContext context) {
        RexNode inputDate = context.rexBuilder.makeCall(PPLBuiltinOperators.DATE, new RexNode[]{fieldExpr});
        RexLiteral epochDate = context.relBuilder.literal((Object)"1970-01-01");
        RexNode daysSinceEpoch = context.rexBuilder.makeCall(PPLBuiltinOperators.DATEDIFF, new RexNode[]{inputDate, epochDate});
        RexNode binStartDays = this.calculateBinStart(daysSinceEpoch, intervalDays, context);
        RexNode binStartDate = context.rexBuilder.makeCall(PPLBuiltinOperators.ADDDATE, new RexNode[]{epochDate, binStartDays});
        return context.rexBuilder.makeCall(PPLBuiltinOperators.TIMESTAMP, new RexNode[]{binStartDate});
    }

    private RexNode calculateBinStart(RexNode value, int interval, CalcitePlanContext context) {
        RexLiteral intervalLiteral = context.relBuilder.literal((Object)interval);
        RexNode positionInCycle = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MOD, new RexNode[]{value, intervalLiteral});
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SUBTRACT, value, positionInCycle);
    }
}

