/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.RangeFormatter;
import org.opensearch.sql.calcite.utils.binning.SpanInfo;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class LogSpanHelper {
    public RexNode createLogSpanExpression(RexNode fieldExpr, SpanInfo spanInfo, CalcitePlanContext context) {
        double base = spanInfo.getBase();
        double coefficient = spanInfo.getCoefficient();
        RexNode positiveCheck = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{fieldExpr, context.relBuilder.literal((Object)0.0)});
        RexNode adjustedField = fieldExpr;
        if (coefficient != 1.0) {
            adjustedField = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{fieldExpr, context.relBuilder.literal((Object)coefficient)});
        }
        RexNode lnField = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.LN, new RexNode[]{adjustedField});
        RexLiteral lnBase = context.relBuilder.literal((Object)Math.log(base));
        RexNode logValue = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{lnField, lnBase});
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{logValue});
        RexLiteral baseNode = context.relBuilder.literal((Object)base);
        RexLiteral coefficientNode = context.relBuilder.literal((Object)coefficient);
        RexNode basePowerBin = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{baseNode, binNumber});
        RexNode lowerBound = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{coefficientNode, basePowerBin});
        RexNode binPlusOne = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.ADD, new RexNode[]{binNumber, context.relBuilder.literal((Object)1.0)});
        RexNode basePowerBinPlusOne = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, new RexNode[]{baseNode, binPlusOne});
        RexNode upperBound = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{coefficientNode, basePowerBinPlusOne});
        RexNode rangeStr = RangeFormatter.createRangeString(lowerBound, upperBound, context);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{positiveCheck, rangeStr, context.relBuilder.literal((Object)"Invalid")});
    }
}

