/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.cluster.filecache.PruneFileCacheAction;
import org.opensearch.action.admin.cluster.filecache.PruneFileCacheRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestPruneCacheAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_filecache/prune"));
    }

    @Override
    public String getName() {
        return "prune_filecache_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodeIds = this.parseNodeTargeting(request);
        PruneFileCacheRequest pruneFileCacheRequest = new PruneFileCacheRequest(nodeIds);
        pruneFileCacheRequest.timeout(request.paramAsTime("timeout", pruneFileCacheRequest.timeout()));
        return channel -> client.execute(PruneFileCacheAction.INSTANCE, pruneFileCacheRequest, new RestToXContentListener((RestChannel)channel));
    }

    private String[] parseNodeTargeting(RestRequest request) {
        String nodes = request.param("nodes");
        String node = request.param("node");
        if (nodes != null && !nodes.trim().isEmpty()) {
            String[] parsed = Strings.splitStringByCommaToArray((String)nodes);
            return (String[])Arrays.stream(parsed).filter(s -> s != null && !s.trim().isEmpty()).map(String::trim).toArray(String[]::new);
        }
        if (node != null && !node.trim().isEmpty()) {
            return new String[]{node.trim()};
        }
        return null;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

