/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter;

import java.io.IOException;
import java.util.Optional;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeNodeCollector;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;

@ExperimentalApi
public class RangeMatchDimFilter
implements DimensionFilter {
    private final String dimensionName;
    private final Object low;
    private final Object high;
    private final boolean includeLow;
    private final boolean includeHigh;
    private Long lowOrdinal;
    private Long highOrdinal;
    private boolean skipRangeCollection = false;
    private DimensionFilterMapper dimensionFilterMapper;

    public RangeMatchDimFilter(String dimensionName, Object low, Object high, boolean includeLow, boolean includeHigh) {
        this.dimensionName = dimensionName;
        this.low = low;
        this.high = high;
        this.includeLow = includeLow;
        this.includeHigh = includeHigh;
    }

    @Override
    public void initialiseForSegment(StarTreeValues starTreeValues, SearchContext searchContext) {
        this.skipRangeCollection = false;
        this.dimensionFilterMapper = DimensionFilterMapper.Factory.fromMappedFieldType(searchContext.mapperService().fieldType(this.dimensionName), searchContext);
        this.lowOrdinal = 0L;
        if (this.low != null) {
            DimensionFilter.MatchType lowMatchType = this.includeLow ? DimensionFilter.MatchType.GTE : DimensionFilter.MatchType.GT;
            Optional<Long> lowOrdinalFound = this.dimensionFilterMapper.getMatchingOrdinal(this.dimensionName, this.low, starTreeValues, lowMatchType);
            if (lowOrdinalFound.isPresent()) {
                this.lowOrdinal = lowOrdinalFound.get();
            } else {
                this.lowOrdinal = this.highOrdinal = Long.valueOf(Long.MAX_VALUE);
                this.skipRangeCollection = true;
                return;
            }
        }
        this.highOrdinal = Long.MAX_VALUE;
        if (this.high != null) {
            DimensionFilter.MatchType highMatchType = this.includeHigh ? DimensionFilter.MatchType.LTE : DimensionFilter.MatchType.LT;
            Optional<Long> highOrdinalFound = this.dimensionFilterMapper.getMatchingOrdinal(this.dimensionName, this.high, starTreeValues, highMatchType);
            highOrdinalFound.ifPresent(ord -> {
                this.highOrdinal = ord;
            });
        }
    }

    @Override
    public void matchStarTreeNodes(StarTreeNode parentNode, StarTreeValues starTreeValues, StarTreeNodeCollector collector) throws IOException {
        if (parentNode != null && !this.skipRangeCollection) {
            parentNode.collectChildrenInRange(this.lowOrdinal, this.highOrdinal, collector, this.dimensionFilterMapper);
        }
    }

    @Override
    public boolean matchDimValue(long ordinal, StarTreeValues starTreeValues) {
        return this.dimensionFilterMapper.comparator().compare(this.lowOrdinal, ordinal) <= 0 && this.dimensionFilterMapper.comparator().compare(ordinal, this.highOrdinal) <= 0;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    public Object getLow() {
        return this.low;
    }

    public Object getHigh() {
        return this.high;
    }

    public boolean isIncludeLow() {
        return this.includeLow;
    }

    public boolean isIncludeHigh() {
        return this.includeHigh;
    }
}

