/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalColumnsCollapseManager {
    private final TableResultPanel.ColumnAttributes myColumnAttributes;
    private final DataGrid myGrid;

    public HierarchicalColumnsCollapseManager(DataGrid grid, TableResultPanel.ColumnAttributes columnAttributes) {
        this.myColumnAttributes = columnAttributes;
        this.myGrid = grid;
    }

    public boolean isColumnCollapsedSubtree(@NotNull ModelIndex<GridColumn> columnIndex) {
        if (columnIndex == null) {
            HierarchicalColumnsCollapseManager.$$$reportNull$$$0(0);
        }
        if (!columnIndex.isValid((CoreGrid)this.myGrid)) {
            return false;
        }
        return this.isColumnCollapsedSubtree((GridColumn)this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIndex));
    }

    public boolean isColumnCollapsedSubtree(@Nullable GridColumn column) {
        if (column == null) {
            return false;
        }
        Boolean collapsed = this.myColumnAttributes.isCollapsedSubtree(column);
        return collapsed != null ? collapsed : false;
    }

    public void setIsCollapsedSubtree(GridColumn column, boolean collapsed) {
        this.myColumnAttributes.setIsCollapsedSubtree(column, collapsed);
    }

    public boolean isColumnHiddenDueToCollapse(@NotNull ModelIndex<GridColumn> columnIndex) {
        if (columnIndex == null) {
            HierarchicalColumnsCollapseManager.$$$reportNull$$$0(1);
        }
        if (!columnIndex.isValid((CoreGrid)this.myGrid)) {
            return false;
        }
        return this.isColumnHiddenDueToCollapse((GridColumn)this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIndex));
    }

    public boolean isColumnHiddenDueToCollapse(@Nullable GridColumn column) {
        if (column == null) {
            return true;
        }
        Boolean hidden = this.myColumnAttributes.isHiddenDueToCollapse(column);
        return hidden != null ? hidden : false;
    }

    public void setIsHiddenDueToCollapse(GridColumn column, boolean collapsed) {
        this.myColumnAttributes.setHiddenDueToCollapse(column, collapsed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "columnIndex";
        objectArray2[1] = "com/intellij/database/datagrid/HierarchicalColumnsCollapseManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isColumnCollapsedSubtree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isColumnHiddenDueToCollapse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

