/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.cache.client.JpsCachesDownloader;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.model.AffectedModule;
import org.jetbrains.jps.cache.model.DownloadableFileUrl;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.model.OutputLoadResult;

public final class JpsServerClientImpl
implements JpsServerClient {
    private static final Logger LOG = Logger.getInstance(JpsServerClientImpl.class);
    private final String myServerUrl;

    JpsServerClientImpl(@NotNull String serverUrl) {
        if (serverUrl == null) {
            JpsServerClientImpl.$$$reportNull$$$0(0);
        }
        this.myServerUrl = serverUrl;
    }

    @Override
    @Nullable
    public Path downloadMetadataById(@NotNull JpsNettyClient nettyClient, @NotNull String metadataId, @NotNull Path targetDir) {
        if (nettyClient == null) {
            JpsServerClientImpl.$$$reportNull$$$0(1);
        }
        if (metadataId == null) {
            JpsServerClientImpl.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            JpsServerClientImpl.$$$reportNull$$$0(3);
        }
        String downloadUrl = this.myServerUrl + "/metadata/" + metadataId;
        String fileName = "metadata.json";
        DownloadableFileUrl description = new DownloadableFileUrl(downloadUrl, fileName);
        JpsCachesDownloader downloader = new JpsCachesDownloader(Collections.singletonList(description), nettyClient, null);
        LOG.debug("Downloading JPS metadata from: " + downloadUrl);
        try {
            Path metadataFile;
            List<Pair<File, DownloadableFileUrl>> pairs = downloader.download(targetDir.toFile());
            Pair<File, DownloadableFileUrl> first = pairs.isEmpty() ? null : pairs.get(0);
            Path path = metadataFile = first == null ? null : ((File)first.first).toPath();
            if (metadataFile == null) {
                LOG.warn("Failed to download JPS metadata");
                return null;
            }
            return metadataFile;
        }
        catch (ProcessCanceledException | IOException e) {
            if (e instanceof IOException) {
                LOG.warn("Failed to download JPS metadata from URL: " + downloadUrl, e);
            }
            return null;
        }
    }

    @Override
    @Nullable
    public File downloadCacheById(@NotNull JpsLoaderContext context, @NotNull String cacheId, @NotNull File targetDir) {
        block6: {
            if (context == null) {
                JpsServerClientImpl.$$$reportNull$$$0(4);
            }
            if (cacheId == null) {
                JpsServerClientImpl.$$$reportNull$$$0(5);
            }
            if (targetDir == null) {
                JpsServerClientImpl.$$$reportNull$$$0(6);
            }
            String downloadUrl = this.myServerUrl + "/caches/" + cacheId;
            String fileName = "portable-build-cache.zip";
            DownloadableFileUrl description = new DownloadableFileUrl(downloadUrl, fileName);
            JpsCachesDownloader downloader = new JpsCachesDownloader(Collections.singletonList(description), context.getNettyClient(), context);
            LOG.debug("Downloading JPS caches from: " + downloadUrl);
            try {
                File zipFile;
                List<Pair<File, DownloadableFileUrl>> pairs = downloader.download(targetDir);
                Pair first = (Pair)ContainerUtil.getFirstItem(pairs);
                File file = zipFile = first != null ? (File)first.first : null;
                if (zipFile != null) {
                    return zipFile;
                }
                LOG.warn("Failed to download JPS caches");
            }
            catch (ProcessCanceledException | IOException e) {
                if (!(e instanceof IOException)) break block6;
                LOG.warn("Failed to download JPS caches from URL: " + downloadUrl, e);
            }
        }
        return null;
    }

    @Override
    public @Unmodifiable List<OutputLoadResult> downloadCompiledModules(@NotNull JpsLoaderContext context, @NotNull List<AffectedModule> affectedModules) {
        File targetDir;
        if (context == null) {
            JpsServerClientImpl.$$$reportNull$$$0(7);
        }
        if (affectedModules == null) {
            JpsServerClientImpl.$$$reportNull$$$0(8);
        }
        if ((targetDir = new File(PathManager.getPluginTempPath(), "jps-cache-loader")).exists()) {
            FileUtil.delete((File)targetDir);
        }
        targetDir.mkdirs();
        Map<String, AffectedModule> urlToModuleNameMap = affectedModules.stream().collect(Collectors.toMap(module -> this.myServerUrl + "/" + module.getType() + "/" + module.getName() + "/" + module.getHash(), module -> module));
        List descriptions = ContainerUtil.map(urlToModuleNameMap.entrySet(), entry -> new DownloadableFileUrl((String)entry.getKey(), ((AffectedModule)entry.getValue()).getOutPath().getName() + ".zip"));
        JpsCachesDownloader downloader = new JpsCachesDownloader(descriptions, context.getNettyClient(), context);
        List downloadedFiles = new ArrayList();
        try {
            List<Pair<File, DownloadableFileUrl>> download = downloader.download(targetDir);
            downloadedFiles = ContainerUtil.map(download, pair -> (File)pair.first);
            return ContainerUtil.map(download, pair -> {
                String downloadUrl = ((DownloadableFileUrl)pair.second).getDownloadUrl();
                return new OutputLoadResult((File)pair.first, downloadUrl, (AffectedModule)urlToModuleNameMap.get(downloadUrl));
            });
        }
        catch (ProcessCanceledException | IOException e) {
            if (e instanceof IOException) {
                LOG.warn("Failed to download JPS compilation outputs", e);
            }
            if (targetDir.exists()) {
                FileUtil.delete((File)targetDir);
            }
            downloadedFiles.forEach(zipFile -> FileUtil.delete((File)zipFile));
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nettyClient";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataId";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cache/client/JpsServerClientImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadMetadataById";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadCacheById";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadCompiledModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

