/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.PlatformVelocityTracker;
import androidx.compose.ui.input.pointer.util.VelocityTracker1D;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.unit.Velocity;
import androidx.compose.ui.unit.VelocityKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b#\u0010$J\b\u0010%\u001a\u00020\u0015H\u0016J\u001f\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b'\u0010$J\u001f\u0010(\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b)\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000e\u00a8\u0006*"}, d2={"Landroidx/compose/ui/input/pointer/util/DefaultVelocityTracker;", "Landroidx/compose/ui/input/pointer/util/PlatformVelocityTracker;", "<init>", "()V", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "xVelocityTracker", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "yVelocityTracker", "currentPointerPositionAccumulator", "Landroidx/compose/ui/geometry/Offset;", "getCurrentPointerPositionAccumulator-F1C5BW0$ui", "()J", "setCurrentPointerPositionAccumulator-k-4lQ0M$ui", "(J)V", "J", "lastMoveEventTimeStamp", "", "getLastMoveEventTimeStamp$ui", "setLastMoveEventTimeStamp$ui", "addPosition", "", "timeMillis", "position", "addPosition-Uv8p0NA", "(JJ)V", "calculateVelocity", "Landroidx/compose/ui/unit/Velocity;", "maximumVelocity", "calculateVelocity-AH228Gc", "(J)J", "addPointerInputChange", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "offset", "addPointerInputChange-Uv8p0NA", "(Landroidx/compose/ui/input/pointer/PointerInputChange;J)V", "resetTracking", "addPointerInputChangeLegacy", "addPointerInputChangeLegacy-Uv8p0NA", "addPointerInputChangeWithFix", "addPointerInputChangeWithFix-Uv8p0NA", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlatformVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformVelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/DefaultVelocityTracker\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 6 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,170:1\n65#2:171\n69#2:174\n60#3:172\n70#3:175\n22#4:173\n22#4:176\n57#5,4:177\n35#6,5:181\n35#6,5:186\n*S KotlinDebug\n*F\n+ 1 PlatformVelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/DefaultVelocityTracker\n*L\n75#1:171\n76#1:174\n75#1:172\n76#1:175\n75#1:173\n76#1:176\n80#1:177,4\n116#1:181,5\n154#1:186,5\n*E\n"})
public final class DefaultVelocityTracker
implements PlatformVelocityTracker {
    @NotNull
    private final VelocityTracker1D.Strategy strategy = VelocityTracker1D.Strategy.Lsq2;
    @NotNull
    private final VelocityTracker1D xVelocityTracker = new VelocityTracker1D(false, this.strategy, 1, null);
    @NotNull
    private final VelocityTracker1D yVelocityTracker = new VelocityTracker1D(false, this.strategy, 1, null);
    private long currentPointerPositionAccumulator = Offset.Companion.getZero-F1C5BW0();
    private long lastMoveEventTimeStamp;
    public static final int $stable = 8;

    public final long getCurrentPointerPositionAccumulator-F1C5BW0$ui() {
        return this.currentPointerPositionAccumulator;
    }

    public final void setCurrentPointerPositionAccumulator-k-4lQ0M$ui(long l) {
        this.currentPointerPositionAccumulator = l;
    }

    public final long getLastMoveEventTimeStamp$ui() {
        return this.lastMoveEventTimeStamp;
    }

    public final void setLastMoveEventTimeStamp$ui(long l) {
        this.lastMoveEventTimeStamp = l;
    }

    @Override
    public void addPosition-Uv8p0NA(long timeMillis, long l) {
        long l2 = l;
        boolean bl = false;
        long value$iv$iv = l2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        this.xVelocityTracker.addDataPoint(timeMillis, Float.intBitsToFloat(bits$iv$iv$iv));
        l2 = l;
        boolean bl2 = false;
        value$iv$iv = l2;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        this.yVelocityTracker.addDataPoint(timeMillis, Float.intBitsToFloat(bits$iv$iv$iv));
    }

    @Override
    public long calculateVelocity-AH228Gc(long l) {
        boolean value$iv = Velocity.getX-impl(l) > 0.0f && Velocity.getY-impl(l) > 0.0f;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("maximumVelocity should be a positive value. You specified=" + Velocity.toString-impl(l));
        }
        float velocityX = this.xVelocityTracker.calculateVelocity(Velocity.getX-impl(l));
        float velocityY = this.yVelocityTracker.calculateVelocity(Velocity.getY-impl(l));
        return VelocityKt.Velocity(velocityX, velocityY);
    }

    @Override
    public void addPointerInputChange-Uv8p0NA(@NotNull PointerInputChange event, long l) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerKt.getVelocityTrackerAddPointsFix()) {
            this.addPointerInputChangeWithFix-Uv8p0NA(event, l);
        } else {
            this.addPointerInputChangeLegacy-Uv8p0NA(event, l);
        }
    }

    @Override
    public void resetTracking() {
        this.xVelocityTracker.resetTracking();
        this.yVelocityTracker.resetTracking();
        this.lastMoveEventTimeStamp = 0L;
    }

    private final void addPointerInputChangeLegacy-Uv8p0NA(PointerInputChange event, long l) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            this.currentPointerPositionAccumulator = event.getPosition-F1C5BW0();
            this.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U(it.getPosition-F1C5BW0(), previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            this.currentPointerPositionAccumulator = Offset.plus-MK-Hz9U(this.currentPointerPositionAccumulator, historicalDelta);
            this.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U(this.currentPointerPositionAccumulator, l));
        }
        long delta = Offset.minus-MK-Hz9U(event.getPosition-F1C5BW0(), previousPointerPosition);
        this.currentPointerPositionAccumulator = Offset.plus-MK-Hz9U(this.currentPointerPositionAccumulator, delta);
        this.addPosition-Uv8p0NA(event.getUptimeMillis(), Offset.plus-MK-Hz9U(this.currentPointerPositionAccumulator, l));
    }

    private final void addPointerInputChangeWithFix-Uv8p0NA(PointerInputChange event, long l) {
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            this.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange item$iv;
                HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                this.addPosition-Uv8p0NA(it.getUptimeMillis(), Offset.plus-MK-Hz9U(it.getOriginalEventPosition-F1C5BW0$ui(), l));
            }
            this.addPosition-Uv8p0NA(event.getUptimeMillis(), Offset.plus-MK-Hz9U(event.getOriginalEventPosition-F1C5BW0$ui(), l));
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - this.lastMoveEventTimeStamp > 40L) {
            this.resetTracking();
        }
        this.lastMoveEventTimeStamp = event.getUptimeMillis();
    }
}

