﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/SlotSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListSlotsResult {
 public:
  AWS_LEXMODELSV2_API ListSlotsResult() = default;
  AWS_LEXMODELSV2_API ListSlotsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListSlotsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the bot that contains the slots.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListSlotsResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the bot that contains the slots.</p>
   */
  inline const Aws::String& GetBotVersion() const { return m_botVersion; }
  template <typename BotVersionT = Aws::String>
  void SetBotVersion(BotVersionT&& value) {
    m_botVersionHasBeenSet = true;
    m_botVersion = std::forward<BotVersionT>(value);
  }
  template <typename BotVersionT = Aws::String>
  ListSlotsResult& WithBotVersion(BotVersionT&& value) {
    SetBotVersion(std::forward<BotVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The language and locale of the slots in the list.</p>
   */
  inline const Aws::String& GetLocaleId() const { return m_localeId; }
  template <typename LocaleIdT = Aws::String>
  void SetLocaleId(LocaleIdT&& value) {
    m_localeIdHasBeenSet = true;
    m_localeId = std::forward<LocaleIdT>(value);
  }
  template <typename LocaleIdT = Aws::String>
  ListSlotsResult& WithLocaleId(LocaleIdT&& value) {
    SetLocaleId(std::forward<LocaleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the intent that contains the slots.</p>
   */
  inline const Aws::String& GetIntentId() const { return m_intentId; }
  template <typename IntentIdT = Aws::String>
  void SetIntentId(IntentIdT&& value) {
    m_intentIdHasBeenSet = true;
    m_intentId = std::forward<IntentIdT>(value);
  }
  template <typename IntentIdT = Aws::String>
  ListSlotsResult& WithIntentId(IntentIdT&& value) {
    SetIntentId(std::forward<IntentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Summary information for the slots that meet the filter criteria specified in
   * the request. The length of the list is specified in the <code>maxResults</code>
   * parameter of the request. If there are more slots available, the
   * <code>nextToken</code> field contains a token to get the next page of
   * results.</p>
   */
  inline const Aws::Vector<SlotSummary>& GetSlotSummaries() const { return m_slotSummaries; }
  template <typename SlotSummariesT = Aws::Vector<SlotSummary>>
  void SetSlotSummaries(SlotSummariesT&& value) {
    m_slotSummariesHasBeenSet = true;
    m_slotSummaries = std::forward<SlotSummariesT>(value);
  }
  template <typename SlotSummariesT = Aws::Vector<SlotSummary>>
  ListSlotsResult& WithSlotSummaries(SlotSummariesT&& value) {
    SetSlotSummaries(std::forward<SlotSummariesT>(value));
    return *this;
  }
  template <typename SlotSummariesT = SlotSummary>
  ListSlotsResult& AddSlotSummaries(SlotSummariesT&& value) {
    m_slotSummariesHasBeenSet = true;
    m_slotSummaries.emplace_back(std::forward<SlotSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that indicates whether there are more results to return in a response
   * to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is
   * present, you send the contents as the <code>nextToken</code> parameter of a
   * <code>ListSlots</code> operation request to get the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSlotsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSlotsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;

  Aws::String m_botVersion;

  Aws::String m_localeId;

  Aws::String m_intentId;

  Aws::Vector<SlotSummary> m_slotSummaries;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_botIdHasBeenSet = false;
  bool m_botVersionHasBeenSet = false;
  bool m_localeIdHasBeenSet = false;
  bool m_intentIdHasBeenSet = false;
  bool m_slotSummariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
