#include "nv_push_cl9297.h"

#include <stdio.h>





const char *P_PARSE_NV9097_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NV9097_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NV9297_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NV9097_MTHD(idx);

                                                                                                                                                                                    case NV9297_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
        return "NV9297_SET_ALPHA_CIRCULAR_BUFFER_SIZE";
    case NV9297_SET_TEX_HEADER_EXTENDED_DIMENSIONS:
        return "NV9297_SET_TEX_HEADER_EXTENDED_DIMENSIONS";
    case NV9297_SET_ZCULL_ROP_BYPASS:
        return "NV9297_SET_ZCULL_ROP_BYPASS";
    case NV9297_SET_ZCULL_SUBREGION:
        return "NV9297_SET_ZCULL_SUBREGION";
            case NV9297_SET_ZCULL_SUBREGION_ALLOCATION:
        return "NV9297_SET_ZCULL_SUBREGION_ALLOCATION";
    case NV9297_ASSIGN_ZCULL_SUBREGIONS:
        return "NV9297_ASSIGN_ZCULL_SUBREGIONS";
            case NV9297_SET_L1_CONFIGURATION:
        return "NV9297_SET_L1_CONFIGURATION";
                                                                                                    case NV9297_SET_ZCULL_SUBREGION_TO_REPORT:
        return "NV9297_SET_ZCULL_SUBREGION_TO_REPORT";
    case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE:
        return "NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE";
    case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD:
        return "NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD";
    case NV9297_SET_MAX_PATCHES_PER_BATCH:
        return "NV9297_SET_MAX_PATCHES_PER_BATCH";
                                                                                            case NV9297_SET_COLOR_ZERO_BANDWIDTH_CLEAR:
        return "NV9297_SET_COLOR_ZERO_BANDWIDTH_CLEAR";
    case NV9297_SET_Z_ZERO_BANDWIDTH_CLEAR:
        return "NV9297_SET_Z_ZERO_BANDWIDTH_CLEAR";
                                                                        case NV9297_SET_COLOR_TARGET_FORMAT(0):
        return "NV9297_SET_COLOR_TARGET_FORMAT(0)";
    case NV9297_SET_COLOR_TARGET_FORMAT(1):
        return "NV9297_SET_COLOR_TARGET_FORMAT(1)";
    case NV9297_SET_COLOR_TARGET_FORMAT(2):
        return "NV9297_SET_COLOR_TARGET_FORMAT(2)";
    case NV9297_SET_COLOR_TARGET_FORMAT(3):
        return "NV9297_SET_COLOR_TARGET_FORMAT(3)";
    case NV9297_SET_COLOR_TARGET_FORMAT(4):
        return "NV9297_SET_COLOR_TARGET_FORMAT(4)";
    case NV9297_SET_COLOR_TARGET_FORMAT(5):
        return "NV9297_SET_COLOR_TARGET_FORMAT(5)";
    case NV9297_SET_COLOR_TARGET_FORMAT(6):
        return "NV9297_SET_COLOR_TARGET_FORMAT(6)";
    case NV9297_SET_COLOR_TARGET_FORMAT(7):
        return "NV9297_SET_COLOR_TARGET_FORMAT(7)";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    case NV9297_SET_ZCULL_REGION_FORMAT:
        return "NV9297_SET_ZCULL_REGION_FORMAT";
                                                                                                                                                        case NV9297_SET_SHADER_CONTROL:
        return "NV9297_SET_SHADER_CONTROL";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
    }
}

void
P_DUMP_NV9297_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NV9097_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                                                                                                                                  
    case NV9297_SET_ALPHA_CIRCULAR_BUFFER_SIZE:

    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV9297_SET_TEX_HEADER_EXTENDED_DIMENSIONS:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV9297_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV9297_SET_ZCULL_ROP_BYPASS:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_ROP_BYPASS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_ROP_BYPASS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_STALL = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CULL_EVERYTHING = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.THRESHOLD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV9297_SET_ZCULL_SUBREGION:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_SUBREGION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 24) - 1);
        fprintf(fp, "%s.NORMALIZED_ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NV9297_SET_ZCULL_SUBREGION_ALLOCATION:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4:
            fprintf(fp, "Z_16X16X2_4X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4:
            fprintf(fp, "ZS_16X16_4X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2:
            fprintf(fp, "Z_16X16_4X2\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4:
            fprintf(fp, "Z_16X16_2X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV9297_ASSIGN_ZCULL_SUBREGIONS:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.ALGORITHM = ", prefix);
        switch (parsed) {
        case NV9297_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static:
            fprintf(fp, "Static\n");
            break;
        case NV9297_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive:
            fprintf(fp, "Adaptive\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
          
    case NV9297_SET_L1_CONFIGURATION:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.DIRECTLY_ADDRESSABLE_MEMORY = ", prefix);
        switch (parsed) {
        case NV9297_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        case NV9297_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB:
            fprintf(fp, "SIZE_48KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                  
    case NV9297_SET_ZCULL_SUBREGION_TO_REPORT:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT:
            fprintf(fp, "DEPTH_TEST_NO_ACCEPT\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z:
            fprintf(fp, "DEPTH_TEST_LATE_Z\n");
            break;
        case NV9297_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST:
            fprintf(fp, "STENCIL_TEST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV9297_SET_MAX_PATCHES_PER_BATCH:

    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                          
    case NV9297_SET_COLOR_ZERO_BANDWIDTH_CLEAR:

    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV9297_SET_Z_ZERO_BANDWIDTH_CLEAR:

    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                      
    case NV9297_SET_COLOR_TARGET_FORMAT(0):
    case NV9297_SET_COLOR_TARGET_FORMAT(1):
    case NV9297_SET_COLOR_TARGET_FORMAT(2):
    case NV9297_SET_COLOR_TARGET_FORMAT(3):
    case NV9297_SET_COLOR_TARGET_FORMAT(4):
    case NV9297_SET_COLOR_TARGET_FORMAT(5):
    case NV9297_SET_COLOR_TARGET_FORMAT(6):
    case NV9297_SET_COLOR_TARGET_FORMAT(7):

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NV9297_SET_COLOR_TARGET_FORMAT_V_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32:
            fprintf(fp, "RF32_GF32_BF32_AF32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32:
            fprintf(fp, "RS32_GS32_BS32_AS32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32:
            fprintf(fp, "RU32_GU32_BU32_AU32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32:
            fprintf(fp, "RF32_GF32_BF32_X32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32:
            fprintf(fp, "RS32_GS32_BS32_X32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32:
            fprintf(fp, "RU32_GU32_BU32_X32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16:
            fprintf(fp, "RN16_GN16_BN16_AN16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16:
            fprintf(fp, "RS16_GS16_BS16_AS16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16:
            fprintf(fp, "RU16_GU16_BU16_AU16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16:
            fprintf(fp, "RF16_GF16_BF16_AF16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF32_GF32:
            fprintf(fp, "RF32_GF32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS32_GS32:
            fprintf(fp, "RS32_GS32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU32_GU32:
            fprintf(fp, "RU32_GU32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16:
            fprintf(fp, "RF16_GF16_BF16_X16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8R8G8B8:
            fprintf(fp, "A8R8G8B8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8:
            fprintf(fp, "A8RL8GL8BL8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10:
            fprintf(fp, "AU2BU10GU10RU10\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8:
            fprintf(fp, "A8BL8GL8RL8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8:
            fprintf(fp, "AN8BN8GN8RN8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8:
            fprintf(fp, "AS8BS8GS8RS8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8:
            fprintf(fp, "AU8BU8GU8RU8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RN16_GN16:
            fprintf(fp, "RN16_GN16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS16_GS16:
            fprintf(fp, "RS16_GS16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU16_GU16:
            fprintf(fp, "RU16_GU16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF16_GF16:
            fprintf(fp, "RF16_GF16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A2R10G10B10:
            fprintf(fp, "A2R10G10B10\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11:
            fprintf(fp, "BF10GF11RF11\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS32:
            fprintf(fp, "RS32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU32:
            fprintf(fp, "RU32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF32:
            fprintf(fp, "RF32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_X8R8G8B8:
            fprintf(fp, "X8R8G8B8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8:
            fprintf(fp, "X8RL8GL8BL8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R5G6B5:
            fprintf(fp, "R5G6B5\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A1R5G5B5:
            fprintf(fp, "A1R5G5B5\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_GN8RN8:
            fprintf(fp, "GN8RN8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_GS8RS8:
            fprintf(fp, "GS8RS8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_GU8RU8:
            fprintf(fp, "GU8RU8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R16:
            fprintf(fp, "R16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RN16:
            fprintf(fp, "RN16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS16:
            fprintf(fp, "RS16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU16:
            fprintf(fp, "RU16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF16:
            fprintf(fp, "RF16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R8:
            fprintf(fp, "R8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RN8:
            fprintf(fp, "RN8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RS8:
            fprintf(fp, "RS8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RU8:
            fprintf(fp, "RU8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8:
            fprintf(fp, "A8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_X1R5G5B5:
            fprintf(fp, "X1R5G5B5\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8:
            fprintf(fp, "X8BL8GL8RL8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5:
            fprintf(fp, "Z1R5G5B5\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_O1R5G5B5:
            fprintf(fp, "O1R5G5B5\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8:
            fprintf(fp, "Z8R8G8B8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_O8R8G8B8:
            fprintf(fp, "O8R8G8B8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R32:
            fprintf(fp, "R32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A16:
            fprintf(fp, "A16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AF16:
            fprintf(fp, "AF16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_AF32:
            fprintf(fp, "AF32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_A8R8:
            fprintf(fp, "A8R8\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_R16_A16:
            fprintf(fp, "R16_A16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF16_AF16:
            fprintf(fp, "RF16_AF16\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_RF32_AF32:
            fprintf(fp, "RF32_AF32\n");
            break;
        case NV9297_SET_COLOR_TARGET_FORMAT_V_B8G8R8A8:
            fprintf(fp, "B8G8R8A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
    case NV9297_SET_ZCULL_REGION_FORMAT:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4:
            fprintf(fp, "Z_4X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4:
            fprintf(fp, "ZS_4X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2:
            fprintf(fp, "Z_4X2\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4:
            fprintf(fp, "Z_2X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NV9297_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                      
    case NV9297_SET_SHADER_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEFAULT_PARTIAL = ", prefix);
        switch (parsed) {
        case NV9297_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NV9297_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY:
            fprintf(fp, "INFINITY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.ZERO_TIMES_ANYTHING_IS_ZERO = ", prefix);
        switch (parsed) {
        case NV9297_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV9297_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NV9297_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY:
            fprintf(fp, "LEGACY\n");
            break;
        case NV9297_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE:
            fprintf(fp, "FP64_COMPATIBLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_F2I_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NV9297_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO:
            fprintf(fp, "PASS_ZERO\n");
            break;
        case NV9297_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE:
            fprintf(fp, "PASS_INDEFINITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
}
