/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_siggen = R"doc(RFNoC Signal Generator Block

Constructor Specific Documentation:



Args:
    graph : Reference to the rfnoc_graph object this block is attached to
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_make = R"doc(RFNoC Signal Generator Block

Constructor Specific Documentation:



Args:
    graph : Reference to the rfnoc_graph object this block is attached to
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_amplitude = R"doc(Set the amplitude of the signal)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_amplitude = R"doc(Get the amplitude of the signal)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_constant = R"doc(Set a complex constant of the signal)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_constant = R"doc(Get the complex constant of the signal)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_enable = R"doc(Enable the channel)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_enable = R"doc(Get the channel enable state)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_sine_frequency = R"doc(Set the sine frequency in terms of the sample_rate)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_sine_phase_increment = R"doc(Set the sine frequency phase increment)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_sine_phase_increment = R"doc(Get the sine frequency phase increment)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_waveform = R"doc(Set the type of waveform using the siggen_waveform class)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_waveform_string = R"doc(Get the type of waveform as a string)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_waveform = R"doc(Get the waveform)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_set_samples_per_packet = R"doc(Set the number of samples per packet)doc";


static const char* __doc_gr_uhd_rfnoc_siggen_get_samples_per_packet = R"doc(Get the number of samples per packet)doc";
