/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_viterbi_decoder = R"doc(DVB-T Viterbi decoder.

ETSI EN 300 744 Clause 4.3.3 
Mother convolutional code with rate 1/2. 
k=1, n=2, K=6. 
Generator polynomial G1=171(OCT), G2=133(OCT). 
Punctured to obtain rates of 2/3, 3/4, 5/6, 7/8. 
Data Input format: 
000000X0X1 - QPSK. 
0000X0X1X2X3 - 16QAM. 
00X0X1X2X3X4X5 - 64QAM. 
Data Output format: Packed bytes (each bit is data). 
MSB - first, LSB last.

Constructor Specific Documentation:

Create a DVB-T Viterbi decoder.

Args:
    constellation : constellation used.
    hierarchy : hierarchy used.
    coderate : coderate used.
    bsize : block size.)doc";


static const char* __doc_gr_dtv_dvbt_viterbi_decoder_dvbt_viterbi_decoder = R"doc()doc";


static const char* __doc_gr_dtv_dvbt_viterbi_decoder_make = R"doc(DVB-T Viterbi decoder.

ETSI EN 300 744 Clause 4.3.3 
Mother convolutional code with rate 1/2. 
k=1, n=2, K=6. 
Generator polynomial G1=171(OCT), G2=133(OCT). 
Punctured to obtain rates of 2/3, 3/4, 5/6, 7/8. 
Data Input format: 
000000X0X1 - QPSK. 
0000X0X1X2X3 - 16QAM. 
00X0X1X2X3X4X5 - 64QAM. 
Data Output format: Packed bytes (each bit is data). 
MSB - first, LSB last.

Constructor Specific Documentation:

Create a DVB-T Viterbi decoder.

Args:
    constellation : constellation used.
    hierarchy : hierarchy used.
    coderate : coderate used.
    bsize : block size.)doc";
