/* Generated by wayland-scanner 1.24.0 */

#ifndef WLR_OUTPUT_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define WLR_OUTPUT_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wlr_output_management_unstable_v1 The wlr_output_management_unstable_v1 protocol
 * protocol to configure output devices
 *
 * @section page_desc_wlr_output_management_unstable_v1 Description
 *
 * This protocol exposes interfaces to obtain and modify output device
 * configuration.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_wlr_output_management_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_output_manager_v1 - output device configuration manager
 * - @subpage page_iface_zwlr_output_head_v1 - output device
 * - @subpage page_iface_zwlr_output_mode_v1 - output mode
 * - @subpage page_iface_zwlr_output_configuration_v1 - output configuration
 * - @subpage page_iface_zwlr_output_configuration_head_v1 - head configuration
 * @section page_copyright_wlr_output_management_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Purism SPC
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct zwlr_output_configuration_head_v1;
struct zwlr_output_configuration_v1;
struct zwlr_output_head_v1;
struct zwlr_output_manager_v1;
struct zwlr_output_mode_v1;

#ifndef ZWLR_OUTPUT_MANAGER_V1_INTERFACE
#define ZWLR_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_manager_v1 zwlr_output_manager_v1
 * @section page_iface_zwlr_output_manager_v1_desc Description
 *
 * This interface is a manager that allows reading and writing the current
 * output device configuration.
 *
 * Output devices that display pixels (e.g. a physical monitor or a virtual
 * output in a window) are represented as heads. Heads cannot be created nor
 * destroyed by the client, but they can be enabled or disabled and their
 * properties can be changed. Each head may have one or more available modes.
 *
 * Whenever a head appears (e.g. a monitor is plugged in), it will be
 * advertised via the head event. Immediately after the output manager is
 * bound, all current heads are advertised.
 *
 * Whenever a head's properties change, the relevant wlr_output_head events
 * will be sent. Not all head properties will be sent: only properties that
 * have changed need to.
 *
 * Whenever a head disappears (e.g. a monitor is unplugged), a
 * wlr_output_head.finished event will be sent.
 *
 * After one or more heads appear, change or disappear, the done event will
 * be sent. It carries a serial which can be used in a create_configuration
 * request to update heads properties.
 *
 * The information obtained from this protocol should only be used for output
 * configuration purposes. This protocol is not designed to be a generic
 * output property advertisement protocol for regular clients. Instead,
 * protocols such as xdg-output should be used.
 * @section page_iface_zwlr_output_manager_v1_api API
 * See @ref iface_zwlr_output_manager_v1.
 */
/**
 * @defgroup iface_zwlr_output_manager_v1 The zwlr_output_manager_v1 interface
 *
 * This interface is a manager that allows reading and writing the current
 * output device configuration.
 *
 * Output devices that display pixels (e.g. a physical monitor or a virtual
 * output in a window) are represented as heads. Heads cannot be created nor
 * destroyed by the client, but they can be enabled or disabled and their
 * properties can be changed. Each head may have one or more available modes.
 *
 * Whenever a head appears (e.g. a monitor is plugged in), it will be
 * advertised via the head event. Immediately after the output manager is
 * bound, all current heads are advertised.
 *
 * Whenever a head's properties change, the relevant wlr_output_head events
 * will be sent. Not all head properties will be sent: only properties that
 * have changed need to.
 *
 * Whenever a head disappears (e.g. a monitor is unplugged), a
 * wlr_output_head.finished event will be sent.
 *
 * After one or more heads appear, change or disappear, the done event will
 * be sent. It carries a serial which can be used in a create_configuration
 * request to update heads properties.
 *
 * The information obtained from this protocol should only be used for output
 * configuration purposes. This protocol is not designed to be a generic
 * output property advertisement protocol for regular clients. Instead,
 * protocols such as xdg-output should be used.
 */
extern const struct wl_interface zwlr_output_manager_v1_interface;
#endif
#ifndef ZWLR_OUTPUT_HEAD_V1_INTERFACE
#define ZWLR_OUTPUT_HEAD_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_head_v1 zwlr_output_head_v1
 * @section page_iface_zwlr_output_head_v1_desc Description
 *
 * A head is an output device. The difference between a wl_output object and
 * a head is that heads are advertised even if they are turned off. A head
 * object only advertises properties and cannot be used directly to change
 * them.
 *
 * A head has some read-only properties: modes, name, description and
 * physical_size. These cannot be changed by clients.
 *
 * Other properties can be updated via a wlr_output_configuration object.
 *
 * Properties sent via this interface are applied atomically via the
 * wlr_output_manager.done event. No guarantees are made regarding the order
 * in which properties are sent.
 * @section page_iface_zwlr_output_head_v1_api API
 * See @ref iface_zwlr_output_head_v1.
 */
/**
 * @defgroup iface_zwlr_output_head_v1 The zwlr_output_head_v1 interface
 *
 * A head is an output device. The difference between a wl_output object and
 * a head is that heads are advertised even if they are turned off. A head
 * object only advertises properties and cannot be used directly to change
 * them.
 *
 * A head has some read-only properties: modes, name, description and
 * physical_size. These cannot be changed by clients.
 *
 * Other properties can be updated via a wlr_output_configuration object.
 *
 * Properties sent via this interface are applied atomically via the
 * wlr_output_manager.done event. No guarantees are made regarding the order
 * in which properties are sent.
 */
extern const struct wl_interface zwlr_output_head_v1_interface;
#endif
#ifndef ZWLR_OUTPUT_MODE_V1_INTERFACE
#define ZWLR_OUTPUT_MODE_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_mode_v1 zwlr_output_mode_v1
 * @section page_iface_zwlr_output_mode_v1_desc Description
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * wlr_output_manager.done event. No guarantees are made regarding the order
 * in which properties are sent.
 * @section page_iface_zwlr_output_mode_v1_api API
 * See @ref iface_zwlr_output_mode_v1.
 */
/**
 * @defgroup iface_zwlr_output_mode_v1 The zwlr_output_mode_v1 interface
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * wlr_output_manager.done event. No guarantees are made regarding the order
 * in which properties are sent.
 */
extern const struct wl_interface zwlr_output_mode_v1_interface;
#endif
#ifndef ZWLR_OUTPUT_CONFIGURATION_V1_INTERFACE
#define ZWLR_OUTPUT_CONFIGURATION_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_configuration_v1 zwlr_output_configuration_v1
 * @section page_iface_zwlr_output_configuration_v1_desc Description
 *
 * This object is used by the client to describe a full output configuration.
 *
 * First, the client needs to setup the output configuration. Each head can
 * be either enabled (and configured) or disabled. It is a protocol error to
 * send two enable_head or disable_head requests with the same head. It is a
 * protocol error to omit a head in a configuration.
 *
 * Then, the client can apply or test the configuration. The compositor will
 * then reply with a succeeded, failed or cancelled event. Finally the client
 * should destroy the configuration object.
 * @section page_iface_zwlr_output_configuration_v1_api API
 * See @ref iface_zwlr_output_configuration_v1.
 */
/**
 * @defgroup iface_zwlr_output_configuration_v1 The zwlr_output_configuration_v1 interface
 *
 * This object is used by the client to describe a full output configuration.
 *
 * First, the client needs to setup the output configuration. Each head can
 * be either enabled (and configured) or disabled. It is a protocol error to
 * send two enable_head or disable_head requests with the same head. It is a
 * protocol error to omit a head in a configuration.
 *
 * Then, the client can apply or test the configuration. The compositor will
 * then reply with a succeeded, failed or cancelled event. Finally the client
 * should destroy the configuration object.
 */
extern const struct wl_interface zwlr_output_configuration_v1_interface;
#endif
#ifndef ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_INTERFACE
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_INTERFACE
/**
 * @page page_iface_zwlr_output_configuration_head_v1 zwlr_output_configuration_head_v1
 * @section page_iface_zwlr_output_configuration_head_v1_desc Description
 *
 * This object is used by the client to update a single head's configuration.
 *
 * It is a protocol error to set the same property twice.
 * @section page_iface_zwlr_output_configuration_head_v1_api API
 * See @ref iface_zwlr_output_configuration_head_v1.
 */
/**
 * @defgroup iface_zwlr_output_configuration_head_v1 The zwlr_output_configuration_head_v1 interface
 *
 * This object is used by the client to update a single head's configuration.
 *
 * It is a protocol error to set the same property twice.
 */
extern const struct wl_interface zwlr_output_configuration_head_v1_interface;
#endif

/**
 * @ingroup iface_zwlr_output_manager_v1
 * @struct zwlr_output_manager_v1_listener
 */
struct zwlr_output_manager_v1_listener {
	/**
	 * introduce a new head
	 *
	 * This event introduces a new head. This happens whenever a new
	 * head appears (e.g. a monitor is plugged in) or after the output
	 * manager is bound.
	 */
	void (*head)(void *data,
		     struct zwlr_output_manager_v1 *zwlr_output_manager_v1,
		     struct zwlr_output_head_v1 *head);
	/**
	 * sent all information about current configuration
	 *
	 * This event is sent after all information has been sent after
	 * binding to the output manager object and after any subsequent
	 * changes. This applies to child head and mode objects as well. In
	 * other words, this event is sent whenever a head or mode is
	 * created or destroyed and whenever one of their properties has
	 * been changed. Not all state is re-sent each time the current
	 * configuration changes: only the actual changes are sent.
	 *
	 * This allows changes to the output configuration to be seen as
	 * atomic, even if they happen via multiple events.
	 *
	 * A serial is sent to be used in a future create_configuration
	 * request.
	 * @param serial current configuration serial
	 */
	void (*done)(void *data,
		     struct zwlr_output_manager_v1 *zwlr_output_manager_v1,
		     uint32_t serial);
	/**
	 * the compositor has finished with the manager
	 *
	 * This event indicates that the compositor is done sending
	 * manager events. The compositor will destroy the object
	 * immediately after sending this event, so it will become invalid
	 * and the client should release any resources associated with it.
	 */
	void (*finished)(void *data,
			 struct zwlr_output_manager_v1 *zwlr_output_manager_v1);
};

/**
 * @ingroup iface_zwlr_output_manager_v1
 */
static inline int
zwlr_output_manager_v1_add_listener(struct zwlr_output_manager_v1 *zwlr_output_manager_v1,
				    const struct zwlr_output_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_output_manager_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_OUTPUT_MANAGER_V1_CREATE_CONFIGURATION 0
#define ZWLR_OUTPUT_MANAGER_V1_STOP 1

/**
 * @ingroup iface_zwlr_output_manager_v1
 */
#define ZWLR_OUTPUT_MANAGER_V1_HEAD_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_manager_v1
 */
#define ZWLR_OUTPUT_MANAGER_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_manager_v1
 */
#define ZWLR_OUTPUT_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_output_manager_v1
 */
#define ZWLR_OUTPUT_MANAGER_V1_CREATE_CONFIGURATION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_manager_v1
 */
#define ZWLR_OUTPUT_MANAGER_V1_STOP_SINCE_VERSION 1

/** @ingroup iface_zwlr_output_manager_v1 */
static inline void
zwlr_output_manager_v1_set_user_data(struct zwlr_output_manager_v1 *zwlr_output_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_manager_v1, user_data);
}

/** @ingroup iface_zwlr_output_manager_v1 */
static inline void *
zwlr_output_manager_v1_get_user_data(struct zwlr_output_manager_v1 *zwlr_output_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_manager_v1);
}

static inline uint32_t
zwlr_output_manager_v1_get_version(struct zwlr_output_manager_v1 *zwlr_output_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_manager_v1);
}

/** @ingroup iface_zwlr_output_manager_v1 */
static inline void
zwlr_output_manager_v1_destroy(struct zwlr_output_manager_v1 *zwlr_output_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwlr_output_manager_v1);
}

/**
 * @ingroup iface_zwlr_output_manager_v1
 *
 * Create a new output configuration object. This allows to update head
 * properties.
 */
static inline struct zwlr_output_configuration_v1 *
zwlr_output_manager_v1_create_configuration(struct zwlr_output_manager_v1 *zwlr_output_manager_v1, uint32_t serial)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_manager_v1,
			 ZWLR_OUTPUT_MANAGER_V1_CREATE_CONFIGURATION, &zwlr_output_configuration_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_output_manager_v1), 0, NULL, serial);

	return (struct zwlr_output_configuration_v1 *) id;
}

/**
 * @ingroup iface_zwlr_output_manager_v1
 *
 * Indicates the client no longer wishes to receive events for output
 * configuration changes. However the compositor may emit further events,
 * until the finished event is emitted.
 *
 * The client must not send any more requests after this one.
 */
static inline void
zwlr_output_manager_v1_stop(struct zwlr_output_manager_v1 *zwlr_output_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_manager_v1,
			 ZWLR_OUTPUT_MANAGER_V1_STOP, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_manager_v1), 0);
}

#ifndef ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_STATE_ENUM
#define ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_STATE_ENUM
enum zwlr_output_head_v1_adaptive_sync_state {
	/**
	 * adaptive sync is disabled
	 */
	ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_STATE_DISABLED = 0,
	/**
	 * adaptive sync is enabled
	 */
	ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_STATE_ENABLED = 1,
};
#endif /* ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_STATE_ENUM */

/**
 * @ingroup iface_zwlr_output_head_v1
 * @struct zwlr_output_head_v1_listener
 */
struct zwlr_output_head_v1_listener {
	/**
	 * head name
	 *
	 * This event describes the head name.
	 *
	 * The naming convention is compositor defined, but limited to
	 * alphanumeric characters and dashes (-). Each name is unique
	 * among all wlr_output_head objects, but if a wlr_output_head
	 * object is destroyed the same name may be reused later. The names
	 * will also remain consistent across sessions with the same
	 * hardware and software configuration.
	 *
	 * Examples of names include 'HDMI-A-1', 'WL-1', 'X11-1', etc.
	 * However, do not assume that the name is a reflection of an
	 * underlying DRM connector, X11 connection, etc.
	 *
	 * If the compositor implements the xdg-output protocol and this
	 * head is enabled, the xdg_output.name event must report the same
	 * name.
	 *
	 * The name event is sent after a wlr_output_head object is
	 * created. This event is only sent once per object, and the name
	 * does not change over the lifetime of the wlr_output_head object.
	 */
	void (*name)(void *data,
		     struct zwlr_output_head_v1 *zwlr_output_head_v1,
		     const char *name);
	/**
	 * head description
	 *
	 * This event describes a human-readable description of the head.
	 *
	 * The description is a UTF-8 string with no convention defined for
	 * its contents. Examples might include 'Foocorp 11" Display' or
	 * 'Virtual X11 output via :1'. However, do not assume that the
	 * name is a reflection of the make, model, serial of the
	 * underlying DRM connector or the display name of the underlying
	 * X11 connection, etc.
	 *
	 * If the compositor implements xdg-output and this head is
	 * enabled, the xdg_output.description must report the same
	 * description.
	 *
	 * The description event is sent after a wlr_output_head object is
	 * created. This event is only sent once per object, and the
	 * description does not change over the lifetime of the
	 * wlr_output_head object.
	 */
	void (*description)(void *data,
			    struct zwlr_output_head_v1 *zwlr_output_head_v1,
			    const char *description);
	/**
	 * head physical size
	 *
	 * This event describes the physical size of the head. This event
	 * is only sent if the head has a physical size (e.g. is not a
	 * projector or a virtual device).
	 * @param width width in millimeters of the output
	 * @param height height in millimeters of the output
	 */
	void (*physical_size)(void *data,
			      struct zwlr_output_head_v1 *zwlr_output_head_v1,
			      int32_t width,
			      int32_t height);
	/**
	 * introduce a mode
	 *
	 * This event introduces a mode for this head. It is sent once
	 * per supported mode.
	 */
	void (*mode)(void *data,
		     struct zwlr_output_head_v1 *zwlr_output_head_v1,
		     struct zwlr_output_mode_v1 *mode);
	/**
	 * head is enabled or disabled
	 *
	 * This event describes whether the head is enabled. A disabled
	 * head is not mapped to a region of the global compositor space.
	 *
	 * When a head is disabled, some properties (current_mode,
	 * position, transform and scale) are irrelevant.
	 * @param enabled zero if disabled, non-zero if enabled
	 */
	void (*enabled)(void *data,
			struct zwlr_output_head_v1 *zwlr_output_head_v1,
			int32_t enabled);
	/**
	 * current mode
	 *
	 * This event describes the mode currently in use for this head.
	 * It is only sent if the output is enabled.
	 */
	void (*current_mode)(void *data,
			     struct zwlr_output_head_v1 *zwlr_output_head_v1,
			     struct zwlr_output_mode_v1 *mode);
	/**
	 * current position
	 *
	 * This events describes the position of the head in the global
	 * compositor space. It is only sent if the output is enabled.
	 * @param x x position within the global compositor space
	 * @param y y position within the global compositor space
	 */
	void (*position)(void *data,
			 struct zwlr_output_head_v1 *zwlr_output_head_v1,
			 int32_t x,
			 int32_t y);
	/**
	 * current transformation
	 *
	 * This event describes the transformation currently applied to
	 * the head. It is only sent if the output is enabled.
	 */
	void (*transform)(void *data,
			  struct zwlr_output_head_v1 *zwlr_output_head_v1,
			  int32_t transform);
	/**
	 * current scale
	 *
	 * This events describes the scale of the head in the global
	 * compositor space. It is only sent if the output is enabled.
	 */
	void (*scale)(void *data,
		      struct zwlr_output_head_v1 *zwlr_output_head_v1,
		      wl_fixed_t scale);
	/**
	 * the head has disappeared
	 *
	 * This event indicates that the head is no longer available. The
	 * head object becomes inert. Clients should send a destroy request
	 * and release any resources associated with it.
	 */
	void (*finished)(void *data,
			 struct zwlr_output_head_v1 *zwlr_output_head_v1);
	/**
	 * head manufacturer
	 *
	 * This event describes the manufacturer of the head.
	 *
	 * This must report the same make as the wl_output interface does
	 * in its geometry event.
	 *
	 * Together with the model and serial_number events the purpose is
	 * to allow clients to recognize heads from previous sessions and
	 * for example load head-specific configurations back.
	 *
	 * It is not guaranteed this event will be ever sent. A reason for
	 * that can be that the compositor does not have information about
	 * the make of the head or the definition of a make is not sensible
	 * in the current setup, for example in a virtual session. Clients
	 * can still try to identify the head by available information from
	 * other events but should be aware that there is an increased risk
	 * of false positives.
	 *
	 * It is not recommended to display the make string in UI to users.
	 * For that the string provided by the description event should be
	 * preferred.
	 * @since 2
	 */
	void (*make)(void *data,
		     struct zwlr_output_head_v1 *zwlr_output_head_v1,
		     const char *make);
	/**
	 * head model
	 *
	 * This event describes the model of the head.
	 *
	 * This must report the same model as the wl_output interface does
	 * in its geometry event.
	 *
	 * Together with the make and serial_number events the purpose is
	 * to allow clients to recognize heads from previous sessions and
	 * for example load head-specific configurations back.
	 *
	 * It is not guaranteed this event will be ever sent. A reason for
	 * that can be that the compositor does not have information about
	 * the model of the head or the definition of a model is not
	 * sensible in the current setup, for example in a virtual session.
	 * Clients can still try to identify the head by available
	 * information from other events but should be aware that there is
	 * an increased risk of false positives.
	 *
	 * It is not recommended to display the model string in UI to
	 * users. For that the string provided by the description event
	 * should be preferred.
	 * @since 2
	 */
	void (*model)(void *data,
		      struct zwlr_output_head_v1 *zwlr_output_head_v1,
		      const char *model);
	/**
	 * head serial number
	 *
	 * This event describes the serial number of the head.
	 *
	 * Together with the make and model events the purpose is to allow
	 * clients to recognize heads from previous sessions and for
	 * example load head- specific configurations back.
	 *
	 * It is not guaranteed this event will be ever sent. A reason for
	 * that can be that the compositor does not have information about
	 * the serial number of the head or the definition of a serial
	 * number is not sensible in the current setup. Clients can still
	 * try to identify the head by available information from other
	 * events but should be aware that there is an increased risk of
	 * false positives.
	 *
	 * It is not recommended to display the serial_number string in UI
	 * to users. For that the string provided by the description event
	 * should be preferred.
	 * @since 2
	 */
	void (*serial_number)(void *data,
			      struct zwlr_output_head_v1 *zwlr_output_head_v1,
			      const char *serial_number);
	/**
	 * current adaptive sync state
	 *
	 * This event describes whether adaptive sync is currently
	 * enabled for the head or not. Adaptive sync is also known as
	 * Variable Refresh Rate or VRR.
	 * @since 4
	 */
	void (*adaptive_sync)(void *data,
			      struct zwlr_output_head_v1 *zwlr_output_head_v1,
			      uint32_t state);
};

/**
 * @ingroup iface_zwlr_output_head_v1
 */
static inline int
zwlr_output_head_v1_add_listener(struct zwlr_output_head_v1 *zwlr_output_head_v1,
				 const struct zwlr_output_head_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_output_head_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_OUTPUT_HEAD_V1_RELEASE 0

/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_PHYSICAL_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_ENABLED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_CURRENT_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_FINISHED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_MAKE_SINCE_VERSION 2
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_MODEL_SINCE_VERSION 2
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_SERIAL_NUMBER_SINCE_VERSION 2
/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_ADAPTIVE_SYNC_SINCE_VERSION 4

/**
 * @ingroup iface_zwlr_output_head_v1
 */
#define ZWLR_OUTPUT_HEAD_V1_RELEASE_SINCE_VERSION 3

/** @ingroup iface_zwlr_output_head_v1 */
static inline void
zwlr_output_head_v1_set_user_data(struct zwlr_output_head_v1 *zwlr_output_head_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_head_v1, user_data);
}

/** @ingroup iface_zwlr_output_head_v1 */
static inline void *
zwlr_output_head_v1_get_user_data(struct zwlr_output_head_v1 *zwlr_output_head_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_head_v1);
}

static inline uint32_t
zwlr_output_head_v1_get_version(struct zwlr_output_head_v1 *zwlr_output_head_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_head_v1);
}

/** @ingroup iface_zwlr_output_head_v1 */
static inline void
zwlr_output_head_v1_destroy(struct zwlr_output_head_v1 *zwlr_output_head_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwlr_output_head_v1);
}

/**
 * @ingroup iface_zwlr_output_head_v1
 *
 * This request indicates that the client will no longer use this head
 * object.
 */
static inline void
zwlr_output_head_v1_release(struct zwlr_output_head_v1 *zwlr_output_head_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_head_v1,
			 ZWLR_OUTPUT_HEAD_V1_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_head_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwlr_output_mode_v1
 * @struct zwlr_output_mode_v1_listener
 */
struct zwlr_output_mode_v1_listener {
	/**
	 * mode size
	 *
	 * This event describes the mode size. The size is given in
	 * physical hardware units of the output device. This is not
	 * necessarily the same as the output size in the global compositor
	 * space. For instance, the output may be scaled or transformed.
	 * @param width width of the mode in hardware units
	 * @param height height of the mode in hardware units
	 */
	void (*size)(void *data,
		     struct zwlr_output_mode_v1 *zwlr_output_mode_v1,
		     int32_t width,
		     int32_t height);
	/**
	 * mode refresh rate
	 *
	 * This event describes the mode's fixed vertical refresh rate.
	 * It is only sent if the mode has a fixed refresh rate.
	 * @param refresh vertical refresh rate in mHz
	 */
	void (*refresh)(void *data,
			struct zwlr_output_mode_v1 *zwlr_output_mode_v1,
			int32_t refresh);
	/**
	 * mode is preferred
	 *
	 * This event advertises this mode as preferred.
	 */
	void (*preferred)(void *data,
			  struct zwlr_output_mode_v1 *zwlr_output_mode_v1);
	/**
	 * the mode has disappeared
	 *
	 * This event indicates that the mode is no longer available. The
	 * mode object becomes inert. Clients should send a destroy request
	 * and release any resources associated with it.
	 */
	void (*finished)(void *data,
			 struct zwlr_output_mode_v1 *zwlr_output_mode_v1);
};

/**
 * @ingroup iface_zwlr_output_mode_v1
 */
static inline int
zwlr_output_mode_v1_add_listener(struct zwlr_output_mode_v1 *zwlr_output_mode_v1,
				 const struct zwlr_output_mode_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_output_mode_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_OUTPUT_MODE_V1_RELEASE 0

/**
 * @ingroup iface_zwlr_output_mode_v1
 */
#define ZWLR_OUTPUT_MODE_V1_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_mode_v1
 */
#define ZWLR_OUTPUT_MODE_V1_REFRESH_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_mode_v1
 */
#define ZWLR_OUTPUT_MODE_V1_PREFERRED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_mode_v1
 */
#define ZWLR_OUTPUT_MODE_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_output_mode_v1
 */
#define ZWLR_OUTPUT_MODE_V1_RELEASE_SINCE_VERSION 3

/** @ingroup iface_zwlr_output_mode_v1 */
static inline void
zwlr_output_mode_v1_set_user_data(struct zwlr_output_mode_v1 *zwlr_output_mode_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_mode_v1, user_data);
}

/** @ingroup iface_zwlr_output_mode_v1 */
static inline void *
zwlr_output_mode_v1_get_user_data(struct zwlr_output_mode_v1 *zwlr_output_mode_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_mode_v1);
}

static inline uint32_t
zwlr_output_mode_v1_get_version(struct zwlr_output_mode_v1 *zwlr_output_mode_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_mode_v1);
}

/** @ingroup iface_zwlr_output_mode_v1 */
static inline void
zwlr_output_mode_v1_destroy(struct zwlr_output_mode_v1 *zwlr_output_mode_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwlr_output_mode_v1);
}

/**
 * @ingroup iface_zwlr_output_mode_v1
 *
 * This request indicates that the client will no longer use this mode
 * object.
 */
static inline void
zwlr_output_mode_v1_release(struct zwlr_output_mode_v1 *zwlr_output_mode_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_mode_v1,
			 ZWLR_OUTPUT_MODE_V1_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_mode_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_ENUM
#define ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_ENUM
enum zwlr_output_configuration_v1_error {
	/**
	 * head has been configured twice
	 */
	ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_ALREADY_CONFIGURED_HEAD = 1,
	/**
	 * head has not been configured
	 */
	ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_UNCONFIGURED_HEAD = 2,
	/**
	 * request sent after configuration has been applied or tested
	 */
	ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_ALREADY_USED = 3,
};
#endif /* ZWLR_OUTPUT_CONFIGURATION_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_output_configuration_v1
 * @struct zwlr_output_configuration_v1_listener
 */
struct zwlr_output_configuration_v1_listener {
	/**
	 * configuration changes succeeded
	 *
	 * Sent after the compositor has successfully applied the changes
	 * or tested them.
	 *
	 * Upon receiving this event, the client should destroy this
	 * object.
	 *
	 * If the current configuration has changed, events to describe the
	 * changes will be sent followed by a wlr_output_manager.done
	 * event.
	 */
	void (*succeeded)(void *data,
			  struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1);
	/**
	 * configuration changes failed
	 *
	 * Sent if the compositor rejects the changes or failed to apply
	 * them. The compositor should revert any changes made by the apply
	 * request that triggered this event.
	 *
	 * Upon receiving this event, the client should destroy this
	 * object.
	 */
	void (*failed)(void *data,
		       struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1);
	/**
	 * configuration has been cancelled
	 *
	 * Sent if the compositor cancels the configuration because the
	 * state of an output changed and the client has outdated
	 * information (e.g. after an output has been hotplugged).
	 *
	 * The client can create a new configuration with a newer serial
	 * and try again.
	 *
	 * Upon receiving this event, the client should destroy this
	 * object.
	 */
	void (*cancelled)(void *data,
			  struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1);
};

/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
static inline int
zwlr_output_configuration_v1_add_listener(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1,
					  const struct zwlr_output_configuration_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_output_configuration_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_OUTPUT_CONFIGURATION_V1_ENABLE_HEAD 0
#define ZWLR_OUTPUT_CONFIGURATION_V1_DISABLE_HEAD 1
#define ZWLR_OUTPUT_CONFIGURATION_V1_APPLY 2
#define ZWLR_OUTPUT_CONFIGURATION_V1_TEST 3
#define ZWLR_OUTPUT_CONFIGURATION_V1_DESTROY 4

/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_SUCCEEDED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_CANCELLED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_ENABLE_HEAD_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_DISABLE_HEAD_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_TEST_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_output_configuration_v1 */
static inline void
zwlr_output_configuration_v1_set_user_data(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_configuration_v1, user_data);
}

/** @ingroup iface_zwlr_output_configuration_v1 */
static inline void *
zwlr_output_configuration_v1_get_user_data(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_configuration_v1);
}

static inline uint32_t
zwlr_output_configuration_v1_get_version(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1);
}

/**
 * @ingroup iface_zwlr_output_configuration_v1
 *
 * Enable a head. This request creates a head configuration object that can
 * be used to change the head's properties.
 */
static inline struct zwlr_output_configuration_head_v1 *
zwlr_output_configuration_v1_enable_head(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1, struct zwlr_output_head_v1 *head)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_v1,
			 ZWLR_OUTPUT_CONFIGURATION_V1_ENABLE_HEAD, &zwlr_output_configuration_head_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1), 0, NULL, head);

	return (struct zwlr_output_configuration_head_v1 *) id;
}

/**
 * @ingroup iface_zwlr_output_configuration_v1
 *
 * Disable a head.
 */
static inline void
zwlr_output_configuration_v1_disable_head(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1, struct zwlr_output_head_v1 *head)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_v1,
			 ZWLR_OUTPUT_CONFIGURATION_V1_DISABLE_HEAD, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1), 0, head);
}

/**
 * @ingroup iface_zwlr_output_configuration_v1
 *
 * Apply the new output configuration.
 *
 * In case the configuration is successfully applied, there is no guarantee
 * that the new output state matches completely the requested
 * configuration. For instance, a compositor might round the scale if it
 * doesn't support fractional scaling.
 *
 * After this request has been sent, the compositor must respond with an
 * succeeded, failed or cancelled event. Sending a request that isn't the
 * destructor is a protocol error.
 */
static inline void
zwlr_output_configuration_v1_apply(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_v1,
			 ZWLR_OUTPUT_CONFIGURATION_V1_APPLY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1), 0);
}

/**
 * @ingroup iface_zwlr_output_configuration_v1
 *
 * Test the new output configuration. The configuration won't be applied,
 * but will only be validated.
 *
 * Even if the compositor succeeds to test a configuration, applying it may
 * fail.
 *
 * After this request has been sent, the compositor must respond with an
 * succeeded, failed or cancelled event. Sending a request that isn't the
 * destructor is a protocol error.
 */
static inline void
zwlr_output_configuration_v1_test(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_v1,
			 ZWLR_OUTPUT_CONFIGURATION_V1_TEST, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1), 0);
}

/**
 * @ingroup iface_zwlr_output_configuration_v1
 *
 * Using this request a client can tell the compositor that it is not going
 * to use the configuration object anymore. Any changes to the outputs
 * that have not been applied will be discarded.
 *
 * This request also destroys wlr_output_configuration_head objects created
 * via this object.
 */
static inline void
zwlr_output_configuration_v1_destroy(struct zwlr_output_configuration_v1 *zwlr_output_configuration_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_v1,
			 ZWLR_OUTPUT_CONFIGURATION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_ENUM
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_ENUM
enum zwlr_output_configuration_head_v1_error {
	/**
	 * property has already been set
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_ALREADY_SET = 1,
	/**
	 * mode doesn't belong to head
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_MODE = 2,
	/**
	 * mode is invalid
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_CUSTOM_MODE = 3,
	/**
	 * transform value outside enum
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_TRANSFORM = 4,
	/**
	 * scale negative or zero
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_SCALE = 5,
	/**
	 * invalid enum value used in the set_adaptive_sync request
	 * @since 4
	 */
	ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_ADAPTIVE_SYNC_STATE = 6,
};
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_INVALID_ADAPTIVE_SYNC_STATE_SINCE_VERSION 4
#endif /* ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_ERROR_ENUM */

#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_MODE 0
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_CUSTOM_MODE 1
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_POSITION 2
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_TRANSFORM 3
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_SCALE 4
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_ADAPTIVE_SYNC 5


/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_CUSTOM_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 */
#define ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_ADAPTIVE_SYNC_SINCE_VERSION 4

/** @ingroup iface_zwlr_output_configuration_head_v1 */
static inline void
zwlr_output_configuration_head_v1_set_user_data(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_output_configuration_head_v1, user_data);
}

/** @ingroup iface_zwlr_output_configuration_head_v1 */
static inline void *
zwlr_output_configuration_head_v1_get_user_data(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_output_configuration_head_v1);
}

static inline uint32_t
zwlr_output_configuration_head_v1_get_version(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1);
}

/** @ingroup iface_zwlr_output_configuration_head_v1 */
static inline void
zwlr_output_configuration_head_v1_destroy(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwlr_output_configuration_head_v1);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request sets the head's mode.
 */
static inline void
zwlr_output_configuration_head_v1_set_mode(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, struct zwlr_output_mode_v1 *mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, mode);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request assigns a custom mode to the head. The size is given in
 * physical hardware units of the output device. If set to zero, the
 * refresh rate is unspecified.
 *
 * It is a protocol error to set both a mode and a custom mode.
 */
static inline void
zwlr_output_configuration_head_v1_set_custom_mode(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, int32_t width, int32_t height, int32_t refresh)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_CUSTOM_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, width, height, refresh);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request sets the head's position in the global compositor space.
 */
static inline void
zwlr_output_configuration_head_v1_set_position(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, x, y);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request sets the head's transform.
 */
static inline void
zwlr_output_configuration_head_v1_set_transform(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, int32_t transform)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_TRANSFORM, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, transform);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request sets the head's scale.
 */
static inline void
zwlr_output_configuration_head_v1_set_scale(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, wl_fixed_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_SCALE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, scale);
}

/**
 * @ingroup iface_zwlr_output_configuration_head_v1
 *
 * This request enables/disables adaptive sync. Adaptive sync is also
 * known as Variable Refresh Rate or VRR.
 */
static inline void
zwlr_output_configuration_head_v1_set_adaptive_sync(struct zwlr_output_configuration_head_v1 *zwlr_output_configuration_head_v1, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_output_configuration_head_v1,
			 ZWLR_OUTPUT_CONFIGURATION_HEAD_V1_SET_ADAPTIVE_SYNC, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_output_configuration_head_v1), 0, state);
}

#ifdef  __cplusplus
}
#endif

#endif
