﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/arc-region-switch/model/UpdatePlanRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ARCRegionswitch::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdatePlanRequest::SerializePayload() const {
  JsonValue payload;

  if (m_arnHasBeenSet) {
    payload.WithString("arn", m_arn);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_workflowsHasBeenSet) {
    Aws::Utils::Array<JsonValue> workflowsJsonList(m_workflows.size());
    for (unsigned workflowsIndex = 0; workflowsIndex < workflowsJsonList.GetLength(); ++workflowsIndex) {
      workflowsJsonList[workflowsIndex].AsObject(m_workflows[workflowsIndex].Jsonize());
    }
    payload.WithArray("workflows", std::move(workflowsJsonList));
  }

  if (m_executionRoleHasBeenSet) {
    payload.WithString("executionRole", m_executionRole);
  }

  if (m_recoveryTimeObjectiveMinutesHasBeenSet) {
    payload.WithInteger("recoveryTimeObjectiveMinutes", m_recoveryTimeObjectiveMinutes);
  }

  if (m_associatedAlarmsHasBeenSet) {
    JsonValue associatedAlarmsJsonMap;
    for (auto& associatedAlarmsItem : m_associatedAlarms) {
      associatedAlarmsJsonMap.WithObject(associatedAlarmsItem.first, associatedAlarmsItem.second.Jsonize());
    }
    payload.WithObject("associatedAlarms", std::move(associatedAlarmsJsonMap));
  }

  if (m_triggersHasBeenSet) {
    Aws::Utils::Array<JsonValue> triggersJsonList(m_triggers.size());
    for (unsigned triggersIndex = 0; triggersIndex < triggersJsonList.GetLength(); ++triggersIndex) {
      triggersJsonList[triggersIndex].AsObject(m_triggers[triggersIndex].Jsonize());
    }
    payload.WithArray("triggers", std::move(triggersJsonList));
  }

  if (m_reportConfigurationHasBeenSet) {
    payload.WithObject("reportConfiguration", m_reportConfiguration.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdatePlanRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "ArcRegionSwitch.UpdatePlan"));
  return headers;
}

UpdatePlanRequest::EndpointParameters UpdatePlanRequest::GetEndpointContextParams() const {
  EndpointParameters parameters;
  // Static context parameters
  parameters.emplace_back(Aws::String("UseControlPlaneEndpoint"), true, Aws::Endpoint::EndpointParameter::ParameterOrigin::STATIC_CONTEXT);
  return parameters;
}
