// ----------------------------------------------------------------------------
//
//  Copyright (C) 2008-2018 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JGAINCTL_H
#define __JGAINCTL_H


#include <zita-jclient.h>
#include "fader2.h"


class Jgainctl : public Jclient
{
public:

    Jgainctl (const char *client_name, const char *server_name, int nchan);
    virtual ~Jgainctl (void);

    enum { MAXCHAN = 100 };

    void set_gain (int chan, float gdb) { _fader->setgain (chan, gdb); }
    void set_mute (int chan, bool mute) { _fader->setmute (chan, mute); }
    
private:

    int jack_process (int nframes);

    Fader2 *_fader; 
};


#endif
