/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 241 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
#include <qvector.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector2400.cpp"



extern "C" {static void assign_QVector_2400(void *, Py_ssize_t, void *);}
static void assign_QVector_2400(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVector< ::qreal> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVector< ::qreal> *>(sipSrc);
}


extern "C" {static void *array_QVector_2400(Py_ssize_t);}
static void *array_QVector_2400(Py_ssize_t sipNrElem)
{
    return new ::QVector< ::qreal>[sipNrElem];
}


extern "C" {static void *copy_QVector_2400(const void *, Py_ssize_t);}
static void *copy_QVector_2400(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVector< ::qreal>(reinterpret_cast<const ::QVector< ::qreal> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QVector_2400(void *, int);}
static void release_QVector_2400(void *sipCppV, int)
{
    ::QVector< ::qreal> *sipCpp = reinterpret_cast< ::QVector< ::qreal> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QVector_2400(PyObject *, void **, int *, PyObject *);}
static int convertTo_QVector_2400(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QVector< ::qreal> **sipCppPtr = reinterpret_cast< ::QVector< ::qreal> **>(sipCppPtrV);

#line 268 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QVector<qreal> *qv = new QVector<qreal>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        double val = PyFloat_AsDouble(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        qv->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 139 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector2400.cpp"
}


extern "C" {static PyObject *convertFrom_QVector_2400(void *, PyObject *);}
static PyObject *convertFrom_QVector_2400(void *sipCppV, PyObject *)
{
    ::QVector< ::qreal> *sipCpp = reinterpret_cast< ::QVector< ::qreal> *>(sipCppV);

#line 245 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtGui/qpygui_qvector.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        PyObject *pobj = PyFloat_FromDouble(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 169 "/build/pyqt5/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector2400.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QVector_2400 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_27212,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QVector_2400,
    array_QVector_2400,
    copy_QVector_2400,
    release_QVector_2400,
    convertTo_QVector_2400,
    convertFrom_QVector_2400
};
